/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryUtil {
    private LibraryUtil() {
    }

    public static boolean isTypeInLibrary(@Nullable PsiType type2) {
        return LibraryUtil.classIsInLibrary(PsiUtil.resolveClassInClassTypeOnly((PsiType)type2));
    }

    public static boolean classIsInLibrary(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement;
    }

    public static boolean callOnLibraryMethod(@NotNull PsiMethodCallExpression expression2) {
        PsiMethod method = expression2.resolveMethod();
        return method instanceof PsiCompiledElement;
    }

    public static boolean isOverrideOfLibraryMethod(@NotNull PsiMethod method) {
        PsiMethod[] superMethods;
        for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
            PsiClass containingClass = superMethod.getContainingClass();
            if (LibraryUtil.classIsInLibrary(containingClass)) {
                return true;
            }
            if (!LibraryUtil.isOverrideOfLibraryMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    public static boolean isOverrideOfLibraryMethodParameter(@Nullable PsiVariable variable) {
        if (!(variable instanceof PsiParameter)) {
            return false;
        }
        PsiParameter parameter2 = (PsiParameter)variable;
        PsiElement scope = parameter2.getDeclarationScope();
        if (!(scope instanceof PsiMethod)) {
            return false;
        }
        PsiMethod method = (PsiMethod)scope;
        return LibraryUtil.isOverrideOfLibraryMethod(method);
    }
}

