/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.EquivalenceChecker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EqualityCheck {
    private static final CallMatcher OBJECT_EQUALS = CallMatcher.anyOf(CallMatcher.staticCall("java.util.Objects", "equals").parameterCount(2), CallMatcher.staticCall("com.google.common.base.Objects", "equal").parameterCount(2));
    @NotNull
    private final PsiExpression myLeft;
    @NotNull
    private final PsiExpression myRight;
    private final boolean myLeftDereferenced;

    private EqualityCheck(@NotNull PsiExpression left, @NotNull PsiExpression right, boolean leftDereferenced) {
        this.myLeft = left;
        this.myRight = right;
        this.myLeftDereferenced = leftDereferenced;
    }

    @Nullable
    @Contract(value="null -> null")
    public static EqualityCheck from(PsiExpression expression2) {
        if ((expression2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)) instanceof PsiMethodCallExpression) {
            PsiMethodCallExpression call = (PsiMethodCallExpression)expression2;
            if (MethodCallUtils.isEqualsCall(call)) {
                PsiExpression left = call.getMethodExpression().getQualifierExpression();
                PsiExpression right = (PsiExpression)ArrayUtil.getFirstElement((Object[])call.getArgumentList().getExpressions());
                if (left == null || right == null) {
                    return null;
                }
                return new EqualityCheck(left, right, true);
            }
            if (OBJECT_EQUALS.test(call)) {
                PsiExpression[] args = call.getArgumentList().getExpressions();
                return new EqualityCheck(args[0], args[1], false);
            }
        } else if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)expression2;
            EqualityCheck nestedCheck = EqualityCheck.from(ternary.getThenExpression());
            PsiExpression other = ternary.getElseExpression();
            boolean equalsToNull = false;
            if (nestedCheck == null) {
                nestedCheck = EqualityCheck.from(ternary.getElseExpression());
                other = ternary.getThenExpression();
                equalsToNull = true;
            }
            if (nestedCheck != null && nestedCheck.isLeftDereferenced() && other != null) {
                PsiReferenceExpression rightRef;
                PsiReferenceExpression leftRef = ExpressionUtils.getReferenceExpressionFromNullComparison(ternary.getCondition(), equalsToNull);
                EquivalenceChecker equivalence = EquivalenceChecker.getCanonicalPsiEquivalence();
                if (equivalence.expressionsAreEquivalent((PsiExpression)leftRef, nestedCheck.getLeft()) && equivalence.expressionsAreEquivalent((PsiExpression)(rightRef = ExpressionUtils.getReferenceExpressionFromNullComparison(other, true)), nestedCheck.getRight())) {
                    return new EqualityCheck(nestedCheck.getLeft(), nestedCheck.getRight(), false);
                }
            }
        }
        return null;
    }

    @NotNull
    public PsiExpression getLeft() {
        return this.myLeft;
    }

    @NotNull
    public PsiExpression getRight() {
        return this.myRight;
    }

    public boolean isLeftDereferenced() {
        return this.myLeftDereferenced;
    }
}

