/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclarationSearchUtils {
    private DeclarationSearchUtils() {
    }

    public static boolean variableNameResolvesToTarget(@NotNull String variableName2, @NotNull PsiVariable target, @NotNull PsiElement context) {
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiResolveHelper resolveHelper = psiFacade.getResolveHelper();
        PsiVariable variable = resolveHelper.resolveAccessibleReferencedVariable(variableName2, context);
        return target.equals(variable);
    }

    public static PsiExpression findDefinition(@NotNull PsiReferenceExpression referenceExpression, @Nullable PsiVariable variable) {
        PsiCodeBlock block;
        if (variable == null) {
            PsiElement target = referenceExpression.resolve();
            if (!(target instanceof PsiVariable)) {
                return null;
            }
            variable = (PsiVariable)target;
        }
        if ((block = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)) == null) {
            return null;
        }
        PsiElement[] defs = DefUseUtil.getDefs(block, variable, (PsiElement)referenceExpression);
        if (defs.length != 1) {
            return null;
        }
        PsiElement def = defs[0];
        if (def instanceof PsiVariable) {
            PsiVariable target = (PsiVariable)def;
            PsiExpression initializer = target.getInitializer();
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)initializer);
        }
        if (def instanceof PsiReferenceExpression) {
            PsiElement parent = def.getParent();
            if (!(parent instanceof PsiAssignmentExpression)) {
                return null;
            }
            PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
            if (assignmentExpression.getOperationTokenType() != JavaTokenType.EQ) {
                return null;
            }
            return PsiUtil.skipParenthesizedExprDown((PsiExpression)assignmentExpression.getRExpression());
        }
        return null;
    }

    public static boolean isTooExpensiveToSearch(PsiNamedElement element, boolean zeroResult) {
        String name2 = element.getName();
        if (name2 == null) {
            return true;
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        PsiSearchHelper searchHelper = PsiSearchHelper.getInstance((Project)element.getProject());
        SearchScope useScope = element.getUseScope();
        if (!(useScope instanceof GlobalSearchScope)) {
            return false;
        }
        PsiSearchHelper.SearchCostResult cost = searchHelper.isCheapEnoughToSearch(name2, (GlobalSearchScope)useScope, null, progressManager.getProgressIndicator());
        if (cost == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES) {
            return zeroResult;
        }
        return cost == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES;
    }

    public static PsiField findFirstFieldInDeclaration(PsiField field) {
        PsiTypeElement typeElement = field.getTypeElement();
        if (typeElement == null) {
            return field;
        }
        return (PsiField)typeElement.getParent();
    }

    public static PsiField findNextFieldInDeclaration(PsiField field) {
        PsiField nextField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)field, PsiField.class);
        return nextField != null && field.getTypeElement() == nextField.getTypeElement() ? nextField : null;
    }
}

