/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.numeric;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.dataFlow.CommonDataflow;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfLongType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ExpectedTypeUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntegerMultiplicationImplicitCastToLongInspection
extends BaseInspection {
    @NonNls
    private static final Set<String> s_typesToCheck = new HashSet<String>(4);
    public boolean ignoreNonOverflowingCompileTimeConstants = true;

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new IntegerMultiplicationImplicitCastToLongInspectionFix();
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        IElementType tokenType = (IElementType)infos[0];
        if (JavaTokenType.ASTERISK.equals(tokenType)) {
            return InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.problem.descriptor", new Object[0]);
        }
        return InspectionGadgetsBundle.message("integer.shift.implicit.cast.to.long.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.option", new Object[0]), (InspectionProfileEntry)this, "ignoreNonOverflowingCompileTimeConstants");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new IntegerMultiplicationImplicitlyCastToLongVisitor();
    }

    private static boolean isNonLongInteger(PsiType type2) {
        if (type2 == null) {
            return false;
        }
        String text2 = type2.getCanonicalText();
        return s_typesToCheck.contains(text2);
    }

    private static boolean hasInnerMultiplication(@NotNull PsiPolyadicExpression expression2) {
        IElementType tokenType = expression2.getOperationTokenType();
        if (IntegerMultiplicationImplicitCastToLongInspection.isShiftToken(tokenType)) {
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(expression2.getOperands()[0]);
        }
        return Arrays.stream(expression2.getOperands()).anyMatch(operand2 -> IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(operand2));
    }

    private static boolean hasMultiplication(PsiExpression expression2) {
        if ((expression2 = PsiUtil.deparenthesizeExpression((PsiExpression)expression2)) instanceof PsiPrefixExpression) {
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(((PsiPrefixExpression)expression2).getOperand());
        }
        if (expression2 instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression polyExpr = (PsiPolyadicExpression)expression2;
            IElementType tokenType = polyExpr.getOperationTokenType();
            if (tokenType == JavaTokenType.ASTERISK) {
                return true;
            }
            return IntegerMultiplicationImplicitCastToLongInspection.hasInnerMultiplication(polyExpr);
        }
        if (expression2 instanceof PsiConditionalExpression) {
            PsiConditionalExpression ternary = (PsiConditionalExpression)expression2;
            return IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(ternary.getThenExpression()) || IntegerMultiplicationImplicitCastToLongInspection.hasMultiplication(ternary.getElseExpression());
        }
        return false;
    }

    private static boolean isShiftToken(IElementType tokenType) {
        return tokenType.equals(JavaTokenType.LTLT) || tokenType.equals(JavaTokenType.GTGT) || tokenType.equals(JavaTokenType.GTGTGT);
    }

    static {
        s_typesToCheck.add("int");
        s_typesToCheck.add("short");
        s_typesToCheck.add("byte");
        s_typesToCheck.add("char");
        s_typesToCheck.add("java.lang.Integer");
        s_typesToCheck.add("java.lang.Short");
        s_typesToCheck.add("java.lang.Byte");
        s_typesToCheck.add("java.lang.Character");
    }

    private class IntegerMultiplicationImplicitlyCastToLongVisitor
    extends BaseInspectionVisitor {
        private IntegerMultiplicationImplicitlyCastToLongVisitor() {
        }

        public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
            super.visitPolyadicExpression(expression2);
            IElementType tokenType = expression2.getOperationTokenType();
            if (!tokenType.equals(JavaTokenType.ASTERISK) && !tokenType.equals(JavaTokenType.LTLT)) {
                return;
            }
            PsiType type2 = expression2.getType();
            if (!IntegerMultiplicationImplicitCastToLongInspection.isNonLongInteger(type2)) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.hasInnerMultiplication(expression2)) {
                return;
            }
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length < 2 || expression2.getLastChild() instanceof PsiErrorElement) {
                return;
            }
            PsiExpression context = this.getContainingExpression((PsiExpression)expression2);
            if (context == null) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)context.getParent());
            if (parent instanceof PsiTypeCastExpression) {
                PsiType castType = ((PsiTypeCastExpression)parent).getType();
                if (IntegerMultiplicationImplicitCastToLongInspection.isNonLongInteger(castType)) {
                    return;
                }
                if (PsiType.LONG.equals((Object)castType)) {
                    context = (PsiExpression)parent;
                }
            }
            if (!PsiType.LONG.equals((Object)context.getType()) && !PsiType.LONG.equals((Object)ExpectedTypeUtils.findExpectedType(context, true))) {
                return;
            }
            if (IntegerMultiplicationImplicitCastToLongInspection.this.ignoreNonOverflowingCompileTimeConstants) {
                try {
                    if (ExpressionUtils.computeConstantExpression((PsiExpression)expression2, true) != null) {
                        return;
                    }
                }
                catch (ConstantEvaluationOverflowException constantEvaluationOverflowException) {
                    // empty catch block
                }
                if (this.cannotOverflow(expression2, operands2, tokenType.equals(JavaTokenType.LTLT))) {
                    return;
                }
            }
            this.registerError((PsiElement)expression2, tokenType);
        }

        private boolean cannotOverflow(@NotNull PsiPolyadicExpression expression2, PsiExpression[] operands2, boolean shift) {
            CommonDataflow.DataflowResult dfr = CommonDataflow.getDataflowResult((PsiExpression)expression2);
            if (dfr != null) {
                long min = 1L;
                long max = 1L;
                for (PsiExpression operand2 : operands2) {
                    long r4;
                    long r3;
                    long r2;
                    long r1;
                    long nextMax;
                    long nextMin;
                    LongRangeSet set = DfLongType.extractRange(dfr.getDfType(PsiUtil.skipParenthesizedExprDown((PsiExpression)operand2)));
                    if (operand2 == operands2[0]) {
                        min = set.min();
                        max = set.max();
                        continue;
                    }
                    if (shift) {
                        set = set.bitwiseAnd(LongRangeSet.point(63L));
                        nextMin = set.min();
                        nextMax = set.max();
                        if (nextMax >= 32L) {
                            return false;
                        }
                        r1 = min << (int)nextMin;
                        r2 = max << (int)nextMin;
                        r3 = min << (int)nextMax;
                        r4 = max << (int)nextMax;
                    } else {
                        nextMin = set.min();
                        nextMax = set.max();
                        if (this.intOverflow(nextMin) || this.intOverflow(nextMax)) {
                            return false;
                        }
                        r1 = min * nextMin;
                        r2 = max * nextMin;
                        r3 = min * nextMax;
                        r4 = max * nextMax;
                    }
                    if (this.intOverflow(r1) || this.intOverflow(r2) || this.intOverflow(r3) || this.intOverflow(r4)) {
                        return false;
                    }
                    min = Math.min(Math.min(r1, r2), Math.min(r3, r4));
                    max = Math.max(Math.max(r1, r2), Math.max(r3, r4));
                }
            }
            return true;
        }

        private boolean intOverflow(long l) {
            return (long)((int)l) != l && l != 0x80000000L;
        }

        private PsiExpression getContainingExpression(PsiExpression expression2) {
            PsiPolyadicExpression polyParent;
            IElementType tokenType;
            PsiElement parent = expression2.getParent();
            if (parent instanceof PsiPolyadicExpression && TypeConversionUtil.isNumericType((PsiType)((PsiPolyadicExpression)parent).getType()) && (!IntegerMultiplicationImplicitCastToLongInspection.isShiftToken(tokenType = (polyParent = (PsiPolyadicExpression)parent).getOperationTokenType()) || expression2 == polyParent.getOperands()[0])) {
                return this.getContainingExpression((PsiExpression)parent);
            }
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiPrefixExpression || parent instanceof PsiConditionalExpression) {
                return this.getContainingExpression((PsiExpression)parent);
            }
            return expression2;
        }
    }

    private static class IntegerMultiplicationImplicitCastToLongInspectionFix
    extends InspectionGadgetsFix {
        private IntegerMultiplicationImplicitCastToLongInspectionFix() {
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("integer.multiplication.implicit.cast.to.long.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiPolyadicExpression expression2 = (PsiPolyadicExpression)descriptor.getPsiElement();
            PsiExpression[] operands2 = expression2.getOperands();
            if (operands2.length < 2) {
                return;
            }
            PsiExpression exprToCast = operands2.length > 2 || expression2.getOperationTokenType() == JavaTokenType.LTLT ? operands2[0] : Arrays.stream(operands2).map(operand2 -> PsiUtil.deparenthesizeExpression((PsiExpression)operand2)).filter(operand2 -> operand2 instanceof PsiLiteralExpression || operand2 instanceof PsiPrefixExpression && ((PsiPrefixExpression)operand2).getOperand() instanceof PsiLiteral).findFirst().orElse(operands2[0]);
            IntegerMultiplicationImplicitCastToLongInspectionFix.addCast(exprToCast);
        }

        private static void addCast(@NotNull PsiExpression expression2) {
            PsiExpression operand2;
            if (expression2 instanceof PsiPrefixExpression && (operand2 = ((PsiPrefixExpression)expression2).getOperand()) instanceof PsiLiteralExpression) {
                expression2 = operand2;
            }
            String replacementText = expression2 instanceof PsiLiteralExpression ? expression2.getText() + "L" : "(long)" + expression2.getText();
            PsiReplacementUtil.replaceExpression(expression2, replacementText);
        }
    }
}

