/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.util.JavaPsiConstructorUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterNameDiffersFromOverriddenParameterInspection
extends BaseInspection {
    public boolean m_ignoreSingleCharacterNames = false;
    public boolean m_ignoreOverridesOfLibraryMethods = false;

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel optionsPanel = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.character.option", new Object[0]), "m_ignoreSingleCharacterNames");
        optionsPanel.addCheckbox(InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.ignore.library.option", new Object[0]), "m_ignoreOverridesOfLibraryMethods");
        return optionsPanel;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix((String)infos[0], false, false);
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("parameter.name.differs.from.overridden.parameter.problem.descriptor", infos[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ParameterNameDiffersFromOverriddenParameterVisitor();
    }

    private class ParameterNameDiffersFromOverriddenParameterVisitor
    extends BaseInspectionVisitor {
        private ParameterNameDiffersFromOverriddenParameterVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            PsiParameterList parameterList = method.getParameterList();
            if (parameterList.isEmpty()) {
                return;
            }
            PsiMethod superMethod = this.getSuperMethod(method);
            if (superMethod == null) {
                return;
            }
            PsiParameter[] parameters2 = parameterList.getParameters();
            this.checkParameters(superMethod, parameters2);
        }

        @Nullable
        private PsiMethod getSuperMethod(@NotNull PsiMethod method) {
            if (method.isConstructor()) {
                return JavaPsiConstructorUtil.findConstructorInSuperWithParameterTypes((PsiMethod)method, (PsiType[])method.getSignature(PsiSubstitutor.EMPTY).getParameterTypes());
            }
            return MethodUtils.getSuper(method);
        }

        private void checkParameters(@NotNull PsiMethod superMethod, PsiParameter[] parameters2) {
            PsiClass containingClass;
            if (ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreOverridesOfLibraryMethods && (containingClass = superMethod.getContainingClass()) != null && LibraryUtil.classIsInLibrary(containingClass)) {
                return;
            }
            PsiParameterList superParameterList = superMethod.getParameterList();
            PsiParameter[] superParameters = superParameterList.getParameters();
            for (int i = 0; i < parameters2.length; ++i) {
                PsiParameter parameter2 = parameters2[i];
                String parameterName = parameter2.getName();
                String superParameterName = superParameters[i].getName();
                if (superParameterName.equals(parameterName) || ParameterNameDiffersFromOverriddenParameterInspection.this.m_ignoreSingleCharacterNames && superParameterName.length() == 1) continue;
                this.registerVariableError((PsiVariable)parameter2, superParameterName);
            }
        }
    }
}

