/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.ListTable;
import com.intellij.codeInspection.ui.ListWrappingTableModel;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.util.ui.CheckBox;
import com.intellij.util.ui.FormBuilder;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.fixes.SuppressForTestsScopeFix;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.siyeh.ig.ui.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class NonBooleanMethodNameMayNotStartWithQuestionInspection
extends BaseInspection {
    @NonNls
    public String questionString = "add,are,can,check,contains,could,endsWith,equals,has,is,matches,must,put,remove,shall,should,startsWith,was,were,will,would";
    public boolean ignoreBooleanMethods = false;
    public boolean onlyWarnOnBaseMethods = true;
    List<String> questionList = new ArrayList<String>(32);

    public NonBooleanMethodNameMayNotStartWithQuestionInspection() {
        NonBooleanMethodNameMayNotStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public JComponent createOptionsPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        ListTable table = new ListTable(new ListWrappingTableModel(this.questionList, InspectionGadgetsBundle.message("boolean.method.name.must.start.with.question.table.column.name", new Object[0])));
        JPanel tablePanel = UiUtils.createAddRemovePanel(table);
        CheckBox checkBox1 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.with.boolean.return.type.option", new Object[0]), (InspectionProfileEntry)this, "ignoreBooleanMethods");
        CheckBox checkBox2 = new CheckBox(InspectionGadgetsBundle.message("ignore.methods.overriding.super.method", new Object[0]), (InspectionProfileEntry)this, "onlyWarnOnBaseMethods");
        panel2.add((Component)tablePanel, "Center");
        panel2.add((Component)FormBuilder.createFormBuilder().addComponent((JComponent)checkBox1).addComponent((JComponent)checkBox2).getPanel(), "South");
        return panel2;
    }

    @Override
    protected InspectionGadgetsFix @NotNull [] buildFixes(Object ... infos) {
        PsiElement context = (PsiElement)infos[0];
        SuppressForTestsScopeFix suppressFix = SuppressForTestsScopeFix.build(this, context);
        if (suppressFix == null) {
            return new InspectionGadgetsFix[]{new RenameFix()};
        }
        return new InspectionGadgetsFix[]{new RenameFix(), suppressFix};
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.boolean.method.name.must.not.start.with.question.problem.descriptor", new Object[0]);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        NonBooleanMethodNameMayNotStartWithQuestionInspection.parseString(this.questionString, this.questionList);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.questionString = NonBooleanMethodNameMayNotStartWithQuestionInspection.formatString(this.questionList);
        super.writeSettings(element);
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonBooleanMethodNameMayNotStartWithQuestionVisitor();
    }

    private class NonBooleanMethodNameMayNotStartWithQuestionVisitor
    extends BaseInspectionVisitor {
        private NonBooleanMethodNameMayNotStartWithQuestionVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (returnType == null || returnType.equals(PsiType.BOOLEAN)) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspection.this.ignoreBooleanMethods && returnType.equalsToText("java.lang.Boolean")) {
                return;
            }
            String name2 = method.getName();
            boolean startsWithQuestionWord = false;
            for (String question : NonBooleanMethodNameMayNotStartWithQuestionInspection.this.questionList) {
                if (!name2.startsWith(question)) continue;
                if (name2.length() == question.length()) {
                    startsWithQuestionWord = true;
                    break;
                }
                char nextChar = name2.charAt(question.length());
                if (!Character.isUpperCase(nextChar) && nextChar != '_') continue;
                startsWithQuestionWord = true;
                break;
            }
            if (!startsWithQuestionWord) {
                return;
            }
            if (NonBooleanMethodNameMayNotStartWithQuestionInspection.this.onlyWarnOnBaseMethods ? MethodUtils.hasSuper(method) : LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            this.registerMethodError(method, method);
        }
    }
}

