/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.naming;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiVariable;
import com.intellij.util.ui.CheckBox;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.naming.ConventionInspection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class LocalVariableNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 1;
    private static final int DEFAULT_MAX_LENGTH = 20;
    public boolean m_ignoreForLoopParameters = false;
    public boolean m_ignoreCatchParameters = false;

    @Override
    public JComponent @NotNull [] createExtraOptions() {
        return new JComponent[]{new CheckBox(InspectionGadgetsBundle.message("local.variable.naming.convention.ignore.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreForLoopParameters"), new CheckBox(InspectionGadgetsBundle.message("local.variable.naming.convention.ignore.catch.option", new Object[0]), (InspectionProfileEntry)this, "m_ignoreCatchParameters")};
    }

    @Override
    protected String getElementDescription() {
        return InspectionGadgetsBundle.message("local.variable.naming.convention.element.description", new Object[0]);
    }

    @Override
    protected String getDefaultRegex() {
        return "[a-z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 1;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 20;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NamingConventionsVisitor();
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        public void visitLocalVariable(@NotNull PsiLocalVariable variable) {
            PsiForStatement forLoop;
            PsiStatement initialization;
            PsiElement grandparent;
            PsiElement parent;
            super.visitLocalVariable(variable);
            if (LocalVariableNamingConventionInspection.this.m_ignoreForLoopParameters && (parent = variable.getParent()) != null && (grandparent = parent.getParent()) instanceof PsiForStatement && parent.equals(initialization = (forLoop = (PsiForStatement)grandparent).getInitialization())) {
                return;
            }
            String name2 = variable.getName();
            if (LocalVariableNamingConventionInspection.this.isValid(name2)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name2);
        }

        public void visitParameter(@NotNull PsiParameter variable) {
            PsiElement scope = variable.getDeclarationScope();
            boolean isCatchParameter = scope instanceof PsiCatchSection;
            boolean isForeachParameter = scope instanceof PsiForeachStatement;
            if (!isCatchParameter && !isForeachParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.m_ignoreCatchParameters && isCatchParameter) {
                return;
            }
            if (LocalVariableNamingConventionInspection.this.m_ignoreForLoopParameters && isForeachParameter) {
                return;
            }
            String name2 = variable.getName();
            if (LocalVariableNamingConventionInspection.this.isValid(name2)) {
                return;
            }
            this.registerVariableError((PsiVariable)variable, name2);
        }
    }
}

