/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.methodmetrics;

import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;

class NegationCountVisitor
extends JavaRecursiveElementWalkingVisitor {
    private final boolean myIgnoreInAssertStatements;
    private int m_count;
    private boolean ignoring;

    NegationCountVisitor(boolean ignoreInAssertStatements) {
        this.myIgnoreInAssertStatements = ignoreInAssertStatements;
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression2) {
        super.visitPolyadicExpression(expression2);
        IElementType tokenType = expression2.getOperationTokenType();
        if (!this.ignoring && tokenType.equals(JavaTokenType.NE)) {
            this.m_count += expression2.getOperands().length - 1;
        }
    }

    public void visitAnonymousClass(@NotNull PsiAnonymousClass aClass) {
    }

    public void visitPrefixExpression(@NotNull PsiPrefixExpression expression2) {
        super.visitPrefixExpression(expression2);
        if (!this.ignoring && expression2.getOperationTokenType().equals(JavaTokenType.EXCL)) {
            ++this.m_count;
        }
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreInAssertStatements) {
            this.ignoring = true;
        }
        super.visitAssertStatement(statement);
    }

    protected void elementFinished(@NotNull PsiElement element) {
        super.elementFinished(element);
        if (element instanceof PsiAssertStatement) {
            this.ignoring = false;
        }
    }

    public int getCount() {
        return this.m_count;
    }
}

