/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.maturity;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.util.text.StringSearcher;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObsoleteCollectionInspection
extends BaseInspection {
    private static final int MAX_OCCURRENCES = 20;
    public boolean ignoreRequiredObsoleteCollectionTypes = true;

    @NotNull
    public String getID() {
        return "UseOfObsoleteCollectionType";
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("use.obsolete.collection.type.problem.descriptor", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel(InspectionGadgetsBundle.message("use.obsolete.collection.type.ignore.library.arguments.option", new Object[0]), (InspectionProfileEntry)this, "ignoreRequiredObsoleteCollectionTypes");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ObsoleteCollectionVisitor();
    }

    private static boolean isCheapToSearchInFile(@NotNull PsiNamedElement element) {
        if (element.getName() == null) {
            return false;
        }
        return (Boolean)CachedValuesManager.getCachedValue((PsiElement)element, () -> {
            PsiFile file = element.getContainingFile();
            return CachedValueProvider.Result.create((Object)ObsoleteCollectionInspection.calcCheapEnoughToSearchInFile(element, file), (Object[])new Object[]{file});
        });
    }

    private static boolean calcCheapEnoughToSearchInFile(@NotNull PsiNamedElement element, PsiFile file) {
        String name2 = element.getName();
        if (name2 == null) {
            return false;
        }
        StringSearcher searcher = new StringSearcher(name2, true, true);
        CharSequence contents = file.getViewProvider().getContents();
        int[] count = new int[1];
        return searcher.processOccurrences(contents, __ -> {
            count[0] = count[0] + 1;
            return count[0] <= 20;
        });
    }

    private class ObsoleteCollectionVisitor
    extends BaseInspectionVisitor {
        private ObsoleteCollectionVisitor() {
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            super.visitVariable(variable);
            PsiType type2 = variable.getType();
            if (!this.isObsoleteCollectionType(type2)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethodParameter(variable)) {
                return;
            }
            PsiTypeElement typeElement = variable.getTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.checkReferences((PsiNamedElement)variable)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            PsiType returnType = method.getReturnType();
            if (!this.isObsoleteCollectionType(returnType)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod(method)) {
                return;
            }
            PsiTypeElement typeElement = method.getReturnTypeElement();
            if (typeElement == null) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.checkReferences((PsiNamedElement)method)) {
                return;
            }
            this.registerError((PsiElement)typeElement, new Object[0]);
        }

        public void visitNewExpression(@NotNull PsiNewExpression newExpression) {
            super.visitNewExpression(newExpression);
            PsiType type2 = newExpression.getType();
            if (!this.isObsoleteCollectionType(type2)) {
                return;
            }
            if (ObsoleteCollectionInspection.this.ignoreRequiredObsoleteCollectionTypes && this.isRequiredObsoleteCollectionElement((PsiElement)newExpression)) {
                return;
            }
            this.registerNewExpressionError(newExpression, new Object[0]);
        }

        private boolean isObsoleteCollectionType(@Nullable PsiType type2) {
            if (type2 == null) {
                return false;
            }
            PsiType deepComponentType = type2.getDeepComponentType();
            String className2 = TypeUtils.resolvedClassName(deepComponentType);
            return "java.util.Vector".equals(className2) || "java.util.Hashtable".equals(className2) || "java.util.Stack".equals(className2);
        }

        private boolean checkReferences(PsiNamedElement namedElement) {
            PsiFile containingFile = namedElement.getContainingFile();
            if (!this.isOnTheFly() || ObsoleteCollectionInspection.isCheapToSearchInFile(namedElement)) {
                return ReferencesSearch.search((PsiElement)namedElement, (SearchScope)GlobalSearchScope.fileScope((PsiFile)containingFile)).anyMatch(ref -> this.isRequiredObsoleteCollectionElement(ref.getElement()));
            }
            return true;
        }

        private boolean isRequiredObsoleteCollectionElement(PsiElement element) {
            PsiElement parent = element.getParent();
            if (parent instanceof PsiVariable) {
                PsiVariable variable = (PsiVariable)parent;
                PsiType variableType = variable.getType();
                if (this.isObsoleteCollectionType(variableType)) {
                    return true;
                }
            } else if (parent instanceof PsiReturnStatement) {
                PsiType returnType = PsiTypesUtil.getMethodReturnType((PsiElement)parent);
                if (this.isObsoleteCollectionType(returnType)) {
                    return true;
                }
            } else if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignmentExpression = (PsiAssignmentExpression)parent;
                PsiExpression lhs = assignmentExpression.getLExpression();
                PsiType lhsType = lhs.getType();
                if (this.isObsoleteCollectionType(lhsType)) {
                    return true;
                }
            } else if (parent instanceof PsiMethodCallExpression) {
                return this.isRequiredObsoleteCollectionElement(parent);
            }
            if (!(parent instanceof PsiExpressionList)) {
                return false;
            }
            PsiExpressionList argumentList = (PsiExpressionList)parent;
            PsiElement grandParent = parent.getParent();
            if (!(grandParent instanceof PsiCallExpression)) {
                return false;
            }
            PsiCallExpression callExpression = (PsiCallExpression)grandParent;
            int index = this.getIndexOfArgument(argumentList, element);
            PsiMethod method = callExpression.resolveMethod();
            if (method == null) {
                return false;
            }
            PsiParameterList parameterList = method.getParameterList();
            PsiParameter[] parameters2 = parameterList.getParameters();
            if (index >= parameters2.length) {
                PsiParameter lastParameter = parameters2[parameters2.length - 1];
                if (!lastParameter.isVarArgs()) {
                    return false;
                }
                PsiType type2 = lastParameter.getType();
                if (!(type2 instanceof PsiEllipsisType)) {
                    return false;
                }
                PsiEllipsisType ellipsisType = (PsiEllipsisType)type2;
                PsiType componentType = ellipsisType.getComponentType();
                return this.isObsoleteCollectionType(componentType);
            }
            PsiParameter parameter2 = parameters2[index];
            PsiType type3 = parameter2.getType();
            return this.isObsoleteCollectionType(type3);
        }

        private int getIndexOfArgument(PsiExpressionList argumentList, PsiElement argument) {
            PsiExpression[] expressions2 = argumentList.getExpressions();
            int index = -1;
            for (PsiExpression expression2 : expressions2) {
                ++index;
                if (expression2.equals(argument)) break;
            }
            return index;
        }
    }
}

