/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.logging;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.MakeFieldStaticFinalFix;
import com.siyeh.ig.psiutils.JavaLoggingUtils;
import com.siyeh.ig.ui.UiUtils;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class NonStaticFinalLoggerInspection
extends BaseInspection {
    protected final List<String> loggerClassNames = new ArrayList<String>();
    public String loggerClassName = StringUtil.join(JavaLoggingUtils.DEFAULT_LOGGERS, (String)",");

    public NonStaticFinalLoggerInspection() {
        NonStaticFinalLoggerInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public JComponent createOptionsPanel() {
        return UiUtils.createTreeClassChooserList(this.loggerClassNames, InspectionGadgetsBundle.message("logger.class.name", new Object[0]), InspectionGadgetsBundle.message("choose.logger.class", new Object[0]), new String[0]);
    }

    @NotNull
    public String getID() {
        return "NonConstantLogger";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("non.constant.logger.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiField field = (PsiField)infos[0];
        return MakeFieldStaticFinalFix.buildFixUnconditional(field);
    }

    public void readSettings(@NotNull Element element) throws InvalidDataException {
        super.readSettings(element);
        NonStaticFinalLoggerInspection.parseString(this.loggerClassName, this.loggerClassNames);
    }

    public void writeSettings(@NotNull Element element) throws WriteExternalException {
        this.loggerClassName = NonStaticFinalLoggerInspection.formatString(this.loggerClassNames);
        super.writeSettings(element);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new NonStaticFinalLoggerVisitor();
    }

    private class NonStaticFinalLoggerVisitor
    extends BaseInspectionVisitor {
        private NonStaticFinalLoggerVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            PsiField[] fields;
            if (aClass.isInterface() || aClass.isEnum() || aClass.isAnnotationType()) {
                return;
            }
            if (aClass instanceof PsiTypeParameter) {
                return;
            }
            if (aClass.getContainingClass() != null) {
                return;
            }
            for (PsiField field : fields = aClass.getFields()) {
                if (!this.isLogger((PsiVariable)field) || field.hasModifierProperty("static") && field.hasModifierProperty("final")) continue;
                this.registerFieldError(field, field);
            }
        }

        private boolean isLogger(PsiVariable variable) {
            PsiType type2 = variable.getType();
            String text2 = type2.getCanonicalText();
            return NonStaticFinalLoggerInspection.this.loggerClassNames.contains(text2);
        }
    }
}

