/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiClassUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JUnit5PlatformInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (String)infos[0];
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BaseInspectionVisitor(){

            public void visitClass(PsiClass aClass) {
                PsiTypeElement operand2;
                PsiClass runnerClass;
                PsiAnnotationMemberValue value2;
                PsiAnnotation annotation;
                PsiIdentifier nameIdentifier = aClass.getNameIdentifier();
                if (nameIdentifier != null && PsiClassUtil.isRunnableClass((PsiClass)aClass, (boolean)true, (boolean)false) && (annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (String[])new String[]{"org.junit.runner.RunWith"})) != null && (value2 = annotation.findAttributeValue("value")) instanceof PsiClassObjectAccessExpression && (runnerClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)(operand2 = ((PsiClassObjectAccessExpression)value2).getOperand()).getType())) != null && "org.junit.platform.runner.JUnitPlatform".equals(runnerClass.getQualifiedName()) && Arrays.stream(aClass.getMethods()).noneMatch(method -> method.hasModifierProperty("public") && method.getParameterList().isEmpty() && AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.junit.Test", (int)0))) {
                    this.registerError((PsiElement)nameIdentifier, "Class #ref annotated @RunWith(JUnitPlatform.class) lacks test methods");
                }
            }
        };
    }
}

