/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.junit;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.junit.MakePublicStaticVoidFix;
import com.siyeh.ig.psiutils.TestUtils;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection
extends BaseInspection {
    private static final String[] STATIC_CONFIGS = new String[]{"org.junit.BeforeClass", "org.junit.AfterClass", "org.junit.jupiter.api.BeforeAll", "org.junit.jupiter.api.AfterAll"};

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        PsiMethod method = (PsiMethod)infos[0];
        String targetModifier = BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection.isJunit4Annotation((String)infos[1]) ? "public" : "packageLocal";
        return new MakePublicStaticVoidFix(method, true, targetModifier);
    }

    @NotNull
    public String getID() {
        return "BeforeOrAfterWithIncorrectSignature";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("before.class.or.after.class.is.public.static.void.no.arg.problem.descriptor", infos[1]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor();
    }

    protected static boolean isJunit4Annotation(String annotation) {
        return annotation.endsWith("Class");
    }

    private static class BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor
    extends BaseInspectionVisitor {
        private BeforeClassOrAfterClassIsPublicStaticVoidNoArgVisitor() {
        }

        public void visitMethod(@NotNull PsiMethod method) {
            String annotation = Arrays.stream(STATIC_CONFIGS).filter(anno -> AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)anno, (int)1)).findFirst().orElse(null);
            if (annotation == null) {
                return;
            }
            PsiType returnType = method.getReturnType();
            if (returnType == null) {
                return;
            }
            PsiClass targetClass = method.getContainingClass();
            if (targetClass == null) {
                return;
            }
            PsiParameterList parameterList = method.getParameterList();
            boolean junit4Annotation = BeforeClassOrAfterClassIsPublicStaticVoidNoArgInspection.isJunit4Annotation(annotation);
            if (!((!junit4Annotation || parameterList.isEmpty() && method.hasModifierProperty("public")) && returnType.equals(PsiType.VOID) && (method.hasModifierProperty("static") || !junit4Annotation && TestUtils.testInstancePerClass(targetClass)))) {
                this.registerMethodError(method, method, annotation);
            }
        }
    }
}

