/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.jdk;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import com.siyeh.ig.psiutils.VariableNameGenerator;
import org.jetbrains.annotations.NotNull;

public class ForeachStatementInspection
extends BaseInspection {
    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("extended.for.statement.problem.descriptor", new Object[0]);
    }

    @Override
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new ForEachFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ForeachStatementVisitor();
    }

    private static class ForeachStatementVisitor
    extends BaseInspectionVisitor {
        private ForeachStatementVisitor() {
        }

        public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
            super.visitForeachStatement(statement);
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null || !InheritanceUtil.isInheritor((PsiType)iteratedValue2.getType(), (String)"java.lang.Iterable")) {
                return;
            }
            this.registerStatementError((PsiStatement)statement, new Object[0]);
        }
    }

    private static class ForEachFix
    extends InspectionGadgetsFix {
        private ForEachFix() {
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("extended.for.statement.replace.quickfix", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            PsiForeachStatement statement = (PsiForeachStatement)element.getParent();
            assert (statement != null);
            PsiExpression iteratedValue2 = statement.getIteratedValue();
            if (iteratedValue2 == null) {
                return;
            }
            CommentTracker tracker = new CommentTracker();
            StringBuilder newStatement = new StringBuilder();
            PsiParameter iterationParameter = statement.getIterationParameter();
            boolean generateFinalLocals = JavaCodeStyleSettingsFacade.getInstance((Project)project).isGenerateFinalLocals();
            tracker.markUnchanged(iteratedValue2);
            if (iteratedValue2.getType() instanceof PsiArrayType) {
                PsiType type2 = iterationParameter.getType();
                String index = new VariableNameGenerator((PsiElement)statement, VariableKind.LOCAL_VARIABLE).byType((PsiType)PsiType.INT).byName("i", "j", "k").generate(true);
                newStatement.append("for(int ").append(index).append(" = 0;");
                newStatement.append(index).append('<').append(iteratedValue2.getText()).append(".length;");
                newStatement.append(index).append("++)").append("{ ");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(type2.getCanonicalText()).append(' ').append(iterationParameter.getName());
                newStatement.append(" = ").append(iteratedValue2.getText()).append('[').append(index).append("];");
            } else {
                StringBuilder methodCall = new StringBuilder();
                if (ParenthesesUtils.getPrecedence(iteratedValue2) > 1) {
                    methodCall.append('(').append(iteratedValue2.getText()).append(')');
                } else {
                    methodCall.append(iteratedValue2.getText());
                }
                methodCall.append(".iterator()");
                PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression iteratorCall = factory.createExpressionFromText(methodCall.toString(), (PsiElement)iteratedValue2);
                PsiType variableType = GenericsUtil.getVariableTypeByExpressionType((PsiType)iteratorCall.getType());
                if (variableType == null) {
                    return;
                }
                PsiType parameterType = iterationParameter.getType();
                String typeText = parameterType.getCanonicalText();
                newStatement.append("for(").append(variableType.getCanonicalText()).append(' ');
                String iterator = new VariableNameGenerator((PsiElement)statement, VariableKind.LOCAL_VARIABLE).byName("iterator", "iter", "itr").generate(true);
                newStatement.append(iterator).append("=").append(iteratorCall.getText()).append(';');
                newStatement.append(iterator).append(".hasNext();){");
                if (generateFinalLocals) {
                    newStatement.append("final ");
                }
                newStatement.append(typeText).append(' ').append(iterationParameter.getName()).append(" = ").append(iterator).append(".next();");
            }
            PsiStatement body2 = statement.getBody();
            if (body2 instanceof PsiBlockStatement) {
                PsiBlockStatement blockStatement = (PsiBlockStatement)body2;
                PsiCodeBlock block = blockStatement.getCodeBlock();
                PsiElement[] children = block.getChildren();
                for (int i = 1; i < children.length - 1; ++i) {
                    newStatement.append(tracker.text(children[i]));
                }
            } else {
                String bodyText = body2 == null ? "" : tracker.text((PsiElement)body2);
                newStatement.append(bodyText);
            }
            newStatement.append('}');
            PsiReplacementUtil.replaceStatementAndShortenClassNames((PsiStatement)statement, newStatement.toString(), tracker);
        }
    }
}

