/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.intellij.lang.annotations.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PrivateMemberAccessBetweenOuterAndInnerClassInspection
extends BaseInspection {
    @Pattern(value="[a-zA-Z_0-9.-]+")
    @NotNull
    public String getID() {
        return "SyntheticAccessorCall";
    }

    @Nullable
    public String getAlternativeID() {
        return "PrivateMemberAccessBetweenOuterAndInnerClass";
    }

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.problem.descriptor", aClass.getName());
    }

    @Override
    public InspectionGadgetsFix buildFix(Object ... infos) {
        PsiClass aClass = (PsiClass)infos[0];
        String className2 = aClass.getName();
        if (infos.length == 1) {
            return new MakePackagePrivateFix(className2, true);
        }
        PsiMember member = (PsiMember)infos[1];
        String memberName = member instanceof PsiMethod ? member.getName() + "()" : member.getName();
        String elementName = className2 + '.' + memberName;
        return new MakePackagePrivateFix(elementName, false);
    }

    @Override
    public boolean shouldInspect(PsiFile file) {
        if (FileTypeUtils.isInServerPageFile((PsiElement)file)) {
            return false;
        }
        return !PsiUtil.isLanguageLevel11OrHigher((PsiElement)file);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new PrivateMemberAccessFromInnerClassVisitor();
    }

    private static class PrivateMemberAccessFromInnerClassVisitor
    extends BaseInspectionVisitor {
        private PrivateMemberAccessFromInnerClassVisitor() {
        }

        public void visitNewExpression(PsiNewExpression expression2) {
            PsiClass aClass;
            super.visitNewExpression(expression2);
            if (expression2.getType() instanceof PsiArrayType) {
                return;
            }
            PsiMethod constructor = expression2.resolveMethod();
            if (constructor == null) {
                PsiJavaCodeReferenceElement classReference2 = expression2.getClassOrAnonymousClassReference();
                if (classReference2 == null) {
                    return;
                }
                PsiElement target = classReference2.resolve();
                if (!(target instanceof PsiClass)) {
                    return;
                }
                aClass = (PsiClass)target;
                if (aClass.isInterface() || !aClass.hasModifierProperty("private")) {
                    return;
                }
            } else {
                if (!constructor.hasModifierProperty("private")) {
                    return;
                }
                aClass = constructor.getContainingClass();
            }
            if (!PrivateMemberAccessFromInnerClassVisitor.isInnerClassAccess((PsiExpression)expression2, aClass)) {
                return;
            }
            this.registerNewExpressionError(expression2, aClass);
        }

        @Override
        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression2) {
            super.visitReferenceExpression(expression2);
            PsiElement referenceNameElement2 = expression2.getReferenceNameElement();
            if (referenceNameElement2 == null) {
                return;
            }
            JavaResolveResult resolveResult = expression2.advancedResolve(false);
            if (!resolveResult.isAccessible()) {
                return;
            }
            PsiElement element = resolveResult.getElement();
            if (!(element instanceof PsiMethod) && !(element instanceof PsiField)) {
                return;
            }
            PsiMember member = (PsiMember)element;
            if (!member.hasModifierProperty("private")) {
                return;
            }
            Object value2 = ExpressionUtils.computeConstantExpression((PsiExpression)expression2);
            if (value2 != null) {
                return;
            }
            PsiClass memberClass = member.getContainingClass();
            if (!PrivateMemberAccessFromInnerClassVisitor.isInnerClassAccess((PsiExpression)expression2, memberClass)) {
                return;
            }
            this.registerError(referenceNameElement2, memberClass, member);
        }

        private static boolean isInnerClassAccess(PsiExpression reference, PsiClass targetClass) {
            PsiClass sourceClass = ClassUtils.getContainingClass((PsiElement)reference);
            return sourceClass != null && targetClass != null && sourceClass != targetClass && PsiUtil.getTopLevelClass((PsiElement)sourceClass) == PsiUtil.getTopLevelClass((PsiElement)targetClass);
        }
    }

    private static class MakePackagePrivateFix
    extends InspectionGadgetsFix {
        private final String elementName;
        private final boolean constructor;

        private MakePackagePrivateFix(String elementName, boolean constructor) {
            this.elementName = elementName;
            this.constructor = constructor;
        }

        @NotNull
        public String getName() {
            if (this.constructor) {
                return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.constructor.package.local.quickfix", this.elementName);
            }
            return InspectionGadgetsBundle.message("private.member.access.between.outer.and.inner.classes.make.local.quickfix", this.elementName);
        }

        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("make.package.private.fix.family.name", new Object[0]);
        }

        @Override
        public void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (this.constructor) {
                MakePackagePrivateFix.makeConstructorPackageLocal(project, element);
            } else {
                MakePackagePrivateFix.makeMemberPackageLocal(element);
            }
        }

        private static void makeMemberPackageLocal(PsiElement element) {
            PsiElement parent = element.getParent();
            PsiReferenceExpression reference = (PsiReferenceExpression)parent;
            PsiModifierListOwner member = (PsiModifierListOwner)reference.resolve();
            if (member == null) {
                return;
            }
            PsiModifierList modifiers = member.getModifierList();
            if (modifiers == null) {
                return;
            }
            modifiers.setModifierProperty("public", false);
            modifiers.setModifierProperty("protected", false);
            modifiers.setModifierProperty("private", false);
        }

        private static void makeConstructorPackageLocal(Project project, PsiElement element) {
            PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
            if (newExpression == null) {
                return;
            }
            PsiMethod constructor = newExpression.resolveConstructor();
            if (constructor != null) {
                PsiModifierList modifierList = constructor.getModifierList();
                modifierList.setModifierProperty("private", false);
                return;
            }
            PsiJavaCodeReferenceElement referenceElement = (PsiJavaCodeReferenceElement)element;
            PsiElement target = referenceElement.resolve();
            if (!(target instanceof PsiClass)) {
                return;
            }
            PsiClass aClass = (PsiClass)target;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiMethod newConstructor = elementFactory.createConstructor();
            PsiModifierList modifierList = newConstructor.getModifierList();
            modifierList.setModifierProperty("packageLocal", true);
            aClass.add((PsiElement)newConstructor);
        }
    }
}

