/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.j2me;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ui.SingleIntegerFieldOptionsPanel;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import java.util.Arrays;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class OverlyLargePrimitiveArrayInitializerInspection
extends BaseInspection {
    public int m_limit = 64;

    @Override
    @NotNull
    public String buildErrorString(Object ... infos) {
        Integer numElements = (Integer)infos[0];
        return InspectionGadgetsBundle.message("large.initializer.primitive.type.array.problem.descriptor", numElements);
    }

    public JComponent createOptionsPanel() {
        return new SingleIntegerFieldOptionsPanel(InspectionGadgetsBundle.message("large.initializer.primitive.type.array.maximum.number.of.elements.option", new Object[0]), (InspectionProfileEntry)this, "m_limit");
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new OverlyLargePrimitiveArrayInitializerVisitor();
    }

    private class OverlyLargePrimitiveArrayInitializerVisitor
    extends BaseInspectionVisitor {
        private OverlyLargePrimitiveArrayInitializerVisitor() {
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression2) {
            super.visitArrayInitializerExpression(expression2);
            PsiType type2 = expression2.getType();
            if (type2 == null) {
                return;
            }
            PsiType componentType = type2.getDeepComponentType();
            if (!(componentType instanceof PsiPrimitiveType)) {
                return;
            }
            int numElements = this.calculateNumElements((PsiExpression)expression2);
            if (numElements <= OverlyLargePrimitiveArrayInitializerInspection.this.m_limit) {
                return;
            }
            this.registerError((PsiElement)expression2, numElements);
        }

        private int calculateNumElements(PsiExpression expression2) {
            if (expression2 instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression arrayExpression = (PsiArrayInitializerExpression)expression2;
                PsiExpression[] initializers = arrayExpression.getInitializers();
                return Arrays.stream(initializers).mapToInt(this::calculateNumElements).sum();
            }
            return 1;
        }
    }
}

