/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.fixes;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.PsiReplacementUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ExpressionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddThisQualifierFix
extends InspectionGadgetsFix {
    private AddThisQualifierFix() {
    }

    @Nullable
    public static AddThisQualifierFix buildFix(PsiExpression expressionToQualify, PsiMember memberAccessed) {
        if (!AddThisQualifierFix.isThisQualifierPossible(expressionToQualify, memberAccessed)) {
            return null;
        }
        return new AddThisQualifierFix();
    }

    private static boolean isThisQualifierPossible(PsiExpression memberAccessExpression, @NotNull PsiMember member) {
        if (member.hasModifierProperty("static")) {
            return false;
        }
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)memberAccessExpression);
        if (InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
            return true;
        }
        while ((containingClass = ClassUtils.getContainingClass((PsiElement)containingClass)) != null && !InheritanceUtil.isInheritorOrSelf((PsiClass)containingClass, (PsiClass)memberClass, (boolean)true)) {
        }
        return containingClass != null && !(containingClass instanceof PsiAnonymousClass);
    }

    @NotNull
    public String getFamilyName() {
        return InspectionGadgetsBundle.message("add.this.qualifier.quickfix", new Object[0]);
    }

    @Override
    public void doFix(Project project, ProblemDescriptor descriptor) {
        PsiReferenceExpression expression2 = (PsiReferenceExpression)descriptor.getPsiElement();
        if (expression2.getQualifierExpression() != null) {
            return;
        }
        PsiExpression thisQualifier = ExpressionUtils.getEffectiveQualifier(expression2);
        if (!(thisQualifier instanceof PsiThisExpression)) {
            return;
        }
        CommentTracker commentTracker = new CommentTracker();
        String newExpression = commentTracker.text((PsiElement)thisQualifier) + "." + commentTracker.text((PsiElement)expression2);
        PsiReplacementUtil.replaceExpressionAndShorten((PsiExpression)expression2, newExpression, commentTracker);
    }
}

