/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.errorhandling;

import com.intellij.psi.PsiClass;
import com.intellij.psi.util.InheritanceUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import org.jetbrains.annotations.NotNull;

public class UncheckedExceptionClassInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("unchecked.exception.class.problem.descriptor", new Object[0]);
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new UncheckedExceptionClassVisitor();
    }

    private static class UncheckedExceptionClassVisitor
    extends BaseInspectionVisitor {
        private UncheckedExceptionClassVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.lang.RuntimeException")) {
                return;
            }
            this.registerClassError(aClass, new Object[0]);
        }
    }
}

