/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.dependency;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.AbstractBaseUastLocalInspectionTool;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.apiUsage.ApiUsageProcessor;
import com.intellij.codeInspection.apiUsage.ApiUsageUastVisitor;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.jvm.JvmModifier;
import com.intellij.lang.jvm.JvmModifiersOwner;
import com.intellij.lang.jvm.actions.ChangeModifierRequest;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MemberRequestsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJvmMember;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextArea;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.psiutils.ClassUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UastUtils;

public final class SuspiciousPackagePrivateAccessInspection
extends AbstractBaseUastLocalInspectionTool {
    private static final Key<SuspiciousPackagePrivateAccessInspection> INSPECTION_KEY = Key.create((String)"SuspiciousPackagePrivateAccess");
    @XCollection
    public List<ModulesSet> MODULES_SETS_LOADED_TOGETHER = new ArrayList<ModulesSet>();
    private final ClearableLazyValue<Map<String, ModulesSet>> myModuleSetByModuleName = ClearableLazyValue.createAtomic(() -> {
        HashMap<String, ModulesSet> result = new HashMap<String, ModulesSet>();
        for (ModulesSet modulesSet : this.MODULES_SETS_LOADED_TOGETHER) {
            for (String module : modulesSet.modules) {
                result.put(module, modulesSet);
            }
        }
        return result;
    });

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return ApiUsageUastVisitor.createPsiElementVisitor(new SuspiciousApiUsageProcessor(holder, (Map)this.myModuleSetByModuleName.getValue()));
    }

    private static boolean canAccessProtectedMember(UElement sourceNode, PsiMember member, PsiClass accessObjectType) {
        PsiClass memberClass = member.getContainingClass();
        if (memberClass == null) {
            return false;
        }
        PsiClass contextClass = SuspiciousPackagePrivateAccessInspection.getContextClass(sourceNode, member instanceof PsiClass);
        if (contextClass == null) {
            return false;
        }
        return SuspiciousPackagePrivateAccessInspection.canAccessProtectedMember(member, memberClass, accessObjectType, member.hasModifierProperty("static"), contextClass);
    }

    private static boolean canAccessProtectedMember(@NotNull PsiMember member, @NotNull PsiClass memberClass, @Nullable PsiClass accessObjectClass, boolean isStatic, @NotNull PsiClass contextClass) {
        if (!ClassUtils.inSamePackage((PsiElement)memberClass, (PsiElement)contextClass)) {
            return true;
        }
        return InheritanceUtil.isInheritorOrSelf((PsiClass)contextClass, (PsiClass)memberClass, (boolean)true) && (member instanceof PsiClass || isStatic || accessObjectClass == null || InheritanceUtil.isInheritorOrSelf((PsiClass)accessObjectClass, (PsiClass)contextClass, (boolean)true));
    }

    @Nullable
    private static PsiClass getContextClass(@NotNull UElement sourceNode, boolean forClassReference) {
        PsiElement sourcePsi = sourceNode.getSourcePsi();
        UClass sourceClass = (UClass)UastUtils.findContaining((PsiElement)sourcePsi, UClass.class);
        if (sourceClass == null) {
            return null;
        }
        if (SuspiciousPackagePrivateAccessInspection.isReferenceBelongsToEnclosingClass(sourceNode, sourceClass, forClassReference)) {
            UClass parentClass = UastUtils.getContainingUClass((UElement)sourceClass);
            return parentClass != null ? parentClass.getJavaPsi() : null;
        }
        return sourceClass.getJavaPsi();
    }

    private static boolean isReferenceBelongsToEnclosingClass(@NotNull UElement sourceNode, @NotNull UClass sourceClass, boolean forClassReference) {
        UElement parent = sourceClass.getUastParent();
        if (parent instanceof UObjectLiteralExpression && ((UCallExpression)parent).getValueArguments().stream().anyMatch(it -> UastUtils.isPsiAncestor((UElement)it, (UElement)sourceNode))) {
            return true;
        }
        return forClassReference && sourceClass.getUastSuperTypes().stream().anyMatch(it -> UastUtils.isPsiAncestor((UElement)it, (UElement)sourceNode));
    }

    @Nullable
    public JComponent createOptionsPanel() {
        final JBTextArea component = new JBTextArea(5, 80);
        component.setText(this.MODULES_SETS_LOADED_TOGETHER.stream().map(it -> String.join((CharSequence)",", it.modules)).collect(Collectors.joining("\n")));
        component.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.clear();
                for (String line : StringUtil.splitByLines((String)component.getText())) {
                    ModulesSet set = new ModulesSet();
                    set.modules = new LinkedHashSet<String>(StringUtil.split((String)line, (String)","));
                    if (set.modules.isEmpty()) continue;
                    SuspiciousPackagePrivateAccessInspection.this.MODULES_SETS_LOADED_TOGETHER.add(set);
                }
                SuspiciousPackagePrivateAccessInspection.this.myModuleSetByModuleName.drop();
            }
        });
        JPanel panel2 = new JPanel(new BorderLayout());
        JPanel labels2 = new JPanel(new FlowLayout(0));
        labels2.add((Component)new JBLabel(InspectionGadgetsBundle.message("groups.of.modules.loaded.together.label", new Object[0])));
        labels2.add((Component)ContextHelpLabel.create((String)InspectionGadgetsBundle.message("groups.of.modules.loaded.together.description", new Object[0])));
        panel2.add((Component)labels2, "North");
        panel2.add((Component)new JBScrollPane((Component)component), "Center");
        return panel2;
    }

    public void readSettings(@NotNull Element node) {
        super.readSettings(node);
        this.myModuleSetByModuleName.drop();
    }

    private static class MarkModulesAsLoadedTogetherFix
    implements LocalQuickFix {
        private final String myModule1;
        private final String myModule2;

        private MarkModulesAsLoadedTogetherFix(String module1, String module2) {
            this.myModule1 = module1;
            this.myModule2 = module2;
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return InspectionGadgetsBundle.message("mark.modules.as.loaded.together.fix.text", this.myModule1, this.myModule2);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("mark.modules.as.loaded.together.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            InspectionProfileImpl profile = InspectionProfileManager.getInstance((Project)project).getCurrentProfile();
            PsiElement psiElement = descriptor.getPsiElement();
            if (psiElement != null) {
                profile.modifyToolSettings(INSPECTION_KEY, psiElement, inspection -> {
                    Map moduleSetByModule = (Map)((SuspiciousPackagePrivateAccessInspection)inspection).myModuleSetByModuleName.getValue();
                    ModulesSet module1Set = (ModulesSet)moduleSetByModule.get(this.myModule1);
                    ModulesSet module2Set = (ModulesSet)moduleSetByModule.get(this.myModule2);
                    if (module1Set == null) {
                        if (module2Set == null) {
                            ModulesSet modulesSet = new ModulesSet();
                            modulesSet.modules.add(this.myModule1);
                            modulesSet.modules.add(this.myModule2);
                            inspection.MODULES_SETS_LOADED_TOGETHER.add(modulesSet);
                        } else {
                            module2Set.modules.add(this.myModule1);
                        }
                    } else if (module2Set == null) {
                        module1Set.modules.add(this.myModule2);
                    } else if (module1Set != module2Set) {
                        module1Set.modules.addAll(module2Set.modules);
                        inspection.MODULES_SETS_LOADED_TOGETHER.remove(module2Set);
                    }
                    ((SuspiciousPackagePrivateAccessInspection)inspection).myModuleSetByModuleName.drop();
                });
            }
        }
    }

    @Tag(value="modules-set")
    public static class ModulesSet {
        @XCollection(elementName="module", valueAttributeName="name")
        @Property(surroundWithTag=false)
        public Set<String> modules = new LinkedHashSet<String>();
    }

    private static class SuspiciousApiUsageProcessor
    implements ApiUsageProcessor {
        private final ProblemsHolder myProblemsHolder;
        private final Map<String, ModulesSet> myModuleNameToModulesSet;

        private SuspiciousApiUsageProcessor(ProblemsHolder problemsHolder, Map<String, ModulesSet> moduleNameToModulesSet) {
            this.myProblemsHolder = problemsHolder;
            this.myModuleNameToModulesSet = moduleNameToModulesSet;
        }

        @Override
        public void processReference(@NotNull UElement sourceNode, @NotNull PsiModifierListOwner target, @Nullable UExpression qualifier) {
            PsiClass accessObjectType = SuspiciousApiUsageProcessor.getAccessObjectType(qualifier);
            if (target instanceof PsiJvmMember) {
                this.checkAccess(sourceNode, (PsiJvmMember)target, accessObjectType);
                if (!(target instanceof PsiClass) && accessObjectType != null) {
                    this.checkAccess(sourceNode, (PsiJvmMember)accessObjectType, null);
                }
            }
        }

        @Override
        public void processMethodOverriding(@NotNull UMethod method, @NotNull PsiMethod targetElement) {
            this.checkOverridePackageLocal(method, (PsiJvmMember)targetElement);
        }

        @Override
        public void processConstructorInvocation(@NotNull UElement sourceNode, @NotNull PsiClass instantiatedClass, @Nullable PsiMethod constructor, @Nullable UClass subclassDeclaration) {
            if (subclassDeclaration == null && constructor != null) {
                this.checkAccess(sourceNode, (PsiJvmMember)constructor, null);
            }
        }

        @Nullable
        private static PsiClass getAccessObjectType(@Nullable UExpression qualifier) {
            if (qualifier == null || qualifier instanceof UThisExpression || qualifier instanceof USuperExpression) {
                return null;
            }
            PsiType type2 = qualifier.getExpressionType();
            if (type2 instanceof PsiClassType) {
                return ((PsiClassType)type2).resolve();
            }
            if (qualifier instanceof UReferenceExpression) {
                return (PsiClass)ObjectUtils.tryCast((Object)((UReferenceExpression)qualifier).resolve(), PsiClass.class);
            }
            return null;
        }

        private void checkAccess(@NotNull UElement sourceNode, @NotNull PsiJvmMember target, @Nullable PsiClass accessObjectType) {
            if (target.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
                this.checkPackageLocalAccess(sourceNode, target, "package-private");
            } else if (target.hasModifier(JvmModifier.PROTECTED) && !SuspiciousPackagePrivateAccessInspection.canAccessProtectedMember(sourceNode, (PsiMember)target, accessObjectType)) {
                this.checkPackageLocalAccess(sourceNode, target, "protected and used not through a subclass here");
            }
        }

        private void checkPackageLocalAccess(@NotNull UElement sourceNode, PsiJvmMember targetElement, String accessType) {
            PsiElement sourcePsi = sourceNode.getSourcePsi();
            if (sourcePsi != null) {
                Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement);
                Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
                if (this.isPackageLocalAccessSuspicious(sourceModule, targetModule) && PsiTreeUtil.getParentOfType((PsiElement)sourcePsi, PsiComment.class) == null) {
                    List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)targetElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
                    String elementDescription = StringUtil.removeHtmlTags((String)StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)targetElement, (boolean)true)));
                    Object[] quickFixes = IntentionWrapper.wrapToQuickFixes((IntentionAction[])fixes.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)targetElement.getContainingFile());
                    this.myProblemsHolder.registerProblem(sourcePsi, InspectionGadgetsBundle.message("inspection.suspicious.package.private.access.description", elementDescription, accessType, targetModule.getName()), (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)new MarkModulesAsLoadedTogetherFix(sourceModule.getName(), targetModule.getName())));
                }
            }
        }

        private void checkOverridePackageLocal(@NotNull UMethod sourceNode, @NotNull PsiJvmMember targetElement) {
            PsiElement sourcePsi = sourceNode.getSourcePsi();
            PsiElement nameIdentifier = UElementKt.getSourcePsiElement((UElement)sourceNode.getUastAnchor());
            if (sourcePsi != null && nameIdentifier != null && targetElement.hasModifier(JvmModifier.PACKAGE_LOCAL)) {
                Module targetModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)targetElement);
                Module sourceModule = ModuleUtilCore.findModuleForPsiElement((PsiElement)sourcePsi);
                if (this.isPackageLocalAccessSuspicious(sourceModule, targetModule)) {
                    List fixes = JvmElementActionFactories.createModifierActions((JvmModifiersOwner)targetElement, (ChangeModifierRequest)MemberRequestsKt.modifierRequest((JvmModifier)JvmModifier.PUBLIC, (boolean)true));
                    String elementDescription = StringUtil.removeHtmlTags((String)StringUtil.capitalize((String)RefactoringUIUtil.getDescription((PsiElement)targetElement, (boolean)false)));
                    String classDescription = StringUtil.removeHtmlTags((String)RefactoringUIUtil.getDescription((PsiElement)targetElement.getParent(), (boolean)false));
                    Object[] quickFixes = IntentionWrapper.wrapToQuickFixes((IntentionAction[])fixes.toArray(IntentionAction.EMPTY_ARRAY), (PsiFile)targetElement.getContainingFile());
                    String problem = InspectionGadgetsBundle.message("inspection.suspicious.package.private.access.problem", elementDescription, classDescription, targetModule.getName());
                    this.myProblemsHolder.registerProblem(nameIdentifier, problem, (LocalQuickFix[])ArrayUtil.append((Object[])quickFixes, (Object)new MarkModulesAsLoadedTogetherFix(sourceModule.getName(), targetModule.getName())));
                }
            }
        }

        private boolean isPackageLocalAccessSuspicious(Module sourceModule, Module targetModule) {
            if (targetModule == null || sourceModule == null || targetModule.equals(sourceModule)) {
                return false;
            }
            ModulesSet sourceGroup = this.myModuleNameToModulesSet.get(sourceModule.getName());
            ModulesSet targetGroup = this.myModuleNameToModulesSet.get(targetModule.getName());
            return sourceGroup == null || sourceGroup != targetGroup;
        }
    }
}

