/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.controlflow;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.MultipleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.ArrayUtilRt;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CodeBlockSurrounder;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodCallUtils;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionalExpressionInspection
extends BaseInspection {
    private static final Logger LOG = Logger.getInstance(ConditionalExpressionInspection.class);
    public boolean ignoreSimpleAssignmentsAndReturns = false;
    public boolean ignoreExpressionContext = true;

    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return InspectionGadgetsBundle.message("conditional.expression.problem.descriptor", new Object[0]);
    }

    public JComponent createOptionsPanel() {
        MultipleCheckboxOptionsPanel panel2 = new MultipleCheckboxOptionsPanel((InspectionProfileEntry)this);
        panel2.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.option", new Object[0]), "ignoreSimpleAssignmentsAndReturns");
        panel2.addCheckbox(InspectionGadgetsBundle.message("conditional.expression.expression.context.option", new Object[0]), "ignoreExpressionContext");
        return panel2;
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        boolean quickFix = (Boolean)infos[0];
        if (!quickFix) {
            return null;
        }
        return new ReplaceWithIfFix();
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new ConditionalExpressionVisitor();
    }

    private class ConditionalExpressionVisitor
    extends BaseInspectionVisitor {
        private ConditionalExpressionVisitor() {
        }

        public void visitConditionalExpression(PsiConditionalExpression expression2) {
            boolean canSurround;
            PsiTypeElement typeElement;
            super.visitConditionalExpression(expression2);
            PsiExpression condition2 = expression2.getCondition();
            PsiElement last = PsiTreeUtil.getDeepestLast((PsiElement)condition2);
            if (last instanceof PsiWhiteSpace) {
                last = last.getPrevSibling();
            }
            if (last instanceof PsiErrorElement) {
                return;
            }
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (parent instanceof PsiLocalVariable && (typeElement = ((PsiLocalVariable)parent).getTypeElement()).isInferredType() && !PsiTypesUtil.isDenotableType((PsiType)typeElement.getType(), (PsiElement)typeElement)) {
                return;
            }
            boolean quickFixOnly = false;
            if (ConditionalExpressionInspection.this.ignoreSimpleAssignmentsAndReturns && (parent instanceof PsiAssignmentExpression || parent instanceof PsiReturnStatement || parent instanceof PsiLocalVariable || parent instanceof PsiLambdaExpression)) {
                quickFixOnly = true;
            }
            if (!((canSurround = CodeBlockSurrounder.canSurround((PsiExpression)expression2)) || !ConditionalExpressionInspection.this.ignoreExpressionContext && this.isVisibleHighlight((PsiElement)expression2))) {
                return;
            }
            if (quickFixOnly && !this.isOnTheFly()) {
                return;
            }
            this.registerError((PsiElement)expression2, quickFixOnly ? ProblemHighlightType.INFORMATION : ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new Object[]{canSurround});
        }
    }

    private static class ReplaceWithIfFix
    extends InspectionGadgetsFix {
        private ReplaceWithIfFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("conditional.expression.quickfix", new Object[0]);
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getPsiElement();
            if (!(element instanceof PsiConditionalExpression)) {
                return;
            }
            PsiConditionalExpression expression2 = (PsiConditionalExpression)element;
            if (!PsiTreeUtil.processElements((PsiElement)expression2, e -> !(e instanceof PsiErrorElement))) {
                return;
            }
            CodeBlockSurrounder surrounder = CodeBlockSurrounder.forExpression((PsiExpression)expression2);
            if (surrounder == null) {
                return;
            }
            CodeBlockSurrounder.SurroundResult result = surrounder.surround();
            expression2 = (PsiConditionalExpression)result.getExpression();
            PsiStatement statement = result.getAnchor();
            PsiVariable variable = statement instanceof PsiDeclarationStatement ? (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiVariable.class) : null;
            PsiExpression thenExpression2 = expression2.getThenExpression();
            PsiExpression elseExpression2 = expression2.getElseExpression();
            PsiExpression condition2 = PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2.getCondition());
            CommentTracker tracker = new CommentTracker();
            String ifText = "if(" + (condition2 == null ? "" : tracker.text((PsiElement)condition2)) + ");\nelse;";
            PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
            PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(ifText, (PsiElement)condition2);
            if (variable != null) {
                int conditionIdx;
                String name2 = variable.getName();
                PsiExpression initializer = variable.getInitializer();
                if (initializer == null) {
                    return;
                }
                PsiTypeElement typeElement = variable.getTypeElement();
                if (typeElement != null && typeElement.isInferredType() && PsiTypesUtil.replaceWithExplicitType((PsiTypeElement)typeElement) == null) {
                    return;
                }
                if (initializer instanceof PsiArrayInitializerExpression && (conditionIdx = ArrayUtilRt.find((Object[])((PsiArrayInitializerExpression)initializer).getInitializers(), (Object)expression2)) >= 0) {
                    initializer = (PsiExpression)initializer.replace((PsiElement)RefactoringUtil.convertInitializerToNormalExpression(initializer, variable.getType()));
                    PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)initializer).getArrayInitializer();
                    LOG.assertTrue(arrayInitializer != null, (Object)initializer.getText());
                    expression2 = (PsiConditionalExpression)arrayInitializer.getInitializers()[conditionIdx];
                    thenExpression2 = expression2.getThenExpression();
                    elseExpression2 = expression2.getElseExpression();
                }
                String thenAssignment = name2 + "=" + ReplaceWithIfFix.getReplacement((PsiElement)initializer, (PsiExpression)expression2, thenExpression2, tracker).getText() + ";";
                String elseAssignment = name2 + "=" + ReplaceWithIfFix.getReplacement((PsiElement)initializer, (PsiExpression)expression2, elseExpression2, tracker).getText() + ";";
                ifStatement.setThenBranch(factory.createStatementFromText(thenAssignment, (PsiElement)initializer));
                ifStatement.setElseBranch(factory.createStatementFromText(elseAssignment, (PsiElement)initializer));
                tracker.delete((PsiElement)initializer);
                PsiElement parent = statement.getParent();
                ifStatement = (PsiIfStatement)parent.addAfter((PsiElement)ifStatement, (PsiElement)statement);
                tracker.insertCommentsBefore((PsiElement)ifStatement);
            } else {
                boolean addBraces = PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class, (boolean)true, (Class[])new Class[]{PsiStatement.class}) != null;
                PsiStatement thenBranch = (PsiStatement)ReplaceWithIfFix.getReplacement((PsiElement)statement, (PsiExpression)expression2, thenExpression2, tracker);
                PsiStatement elseBranch = (PsiStatement)ReplaceWithIfFix.getReplacement((PsiElement)statement, (PsiExpression)expression2, elseExpression2, tracker);
                if (addBraces) {
                    thenBranch = (PsiStatement)BlockUtils.expandSingleStatementToBlockStatement(thenBranch).getParent().getParent();
                    elseBranch = (PsiStatement)BlockUtils.expandSingleStatementToBlockStatement(elseBranch).getParent().getParent();
                }
                ifStatement.setThenBranch(thenBranch);
                ifStatement.setElseBranch(elseBranch);
                ifStatement = (PsiIfStatement)tracker.replaceAndRestoreComments((PsiElement)statement, (PsiElement)ifStatement);
            }
            ifStatement = (PsiIfStatement)CodeStyleManager.getInstance((Project)project).reformat(JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)ifStatement));
            if (!ControlFlowUtils.statementMayCompleteNormally(ifStatement.getThenBranch())) {
                PsiStatement resultingElse;
                if (!(ifStatement.getParent() instanceof PsiCodeBlock)) {
                    ifStatement = BlockUtils.expandSingleStatementToBlockStatement(ifStatement);
                }
                if ((resultingElse = ifStatement.getElseBranch()) != null) {
                    ifStatement.getParent().addAfter((PsiElement)ControlFlowUtils.stripBraces(resultingElse), (PsiElement)ifStatement);
                    resultingElse.delete();
                }
            }
        }

        private static PsiElement getReplacement(@NotNull PsiElement element, @NotNull PsiExpression expressionToReplace, @Nullable PsiExpression replacementExpression, @NotNull CommentTracker tracker) {
            PsiType type2;
            Object marker = new Object();
            while (expressionToReplace.getParent() instanceof PsiParenthesizedExpression) {
                expressionToReplace = (PsiExpression)expressionToReplace.getParent();
            }
            PsiTreeUtil.mark((PsiElement)expressionToReplace, (Object)marker);
            PsiElement copy = element.copy();
            PsiExpression copyToReplace = (PsiExpression)PsiTreeUtil.releaseMark((PsiElement)copy, (Object)marker);
            assert (copyToReplace != null);
            if ((replacementExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)replacementExpression)) == null) {
                replacementExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("()", null);
            } else if ((MethodCallUtils.isNecessaryForSurroundingMethodCall(expressionToReplace, replacementExpression) || ReplaceWithIfFix.isExplicitBoxingNecessary(expressionToReplace, replacementExpression)) && (type2 = expressionToReplace.getType()) != null) {
                replacementExpression = JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("(" + type2.getCanonicalText() + ")" + tracker.text((PsiElement)replacementExpression), null);
            }
            PsiTreeUtil.findChildrenOfType((PsiElement)copy, PsiComment.class).forEach(PsiElement::delete);
            PsiElement result = copyToReplace.replace((PsiElement)tracker.markUnchanged(replacementExpression));
            return copy == copyToReplace ? result : copy;
        }

        private static boolean isExplicitBoxingNecessary(PsiExpression expressionToReplace, PsiExpression replacementExpression) {
            PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier(expressionToReplace);
            return call != null && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)replacementExpression.getType());
        }
    }
}

