/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.classlayout;

import com.intellij.psi.PsiClass;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ClassUtils;
import org.jetbrains.annotations.NotNull;

public class SingletonInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        return (Boolean)infos[0] != false ? InspectionGadgetsBundle.message("enum.singleton.problem.descriptor", new Object[0]) : InspectionGadgetsBundle.message("singleton.problem.descriptor", new Object[0]);
    }

    public boolean runForWholeFile() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SingletonVisitor();
    }

    private static class SingletonVisitor
    extends BaseInspectionVisitor {
        private SingletonVisitor() {
        }

        public void visitClass(@NotNull PsiClass aClass) {
            if (!ClassUtils.isSingleton(aClass)) {
                return;
            }
            this.registerClassError(aClass, aClass.isEnum());
        }
    }
}

