/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.FunctionalExpressionUtils;
import com.siyeh.ig.psiutils.StreamApiUtil;
import com.siyeh.ig.psiutils.TypeUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousToArrayCallInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        PsiType type2 = (PsiType)infos[0];
        PsiType foundType = (PsiType)infos[1];
        return InspectionGadgetsBundle.message("suspicious.to.array.call.problem.descriptor", type2.getCanonicalText(), foundType.getCanonicalText());
    }

    @Override
    @Nullable
    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new SuspiciousToArrayCallFix((PsiType)infos[0], (Boolean)infos[2]);
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new SuspiciousToArrayCallVisitor();
    }

    private static class SuspiciousToArrayCallFix
    extends InspectionGadgetsFix {
        private final String myReplacement;
        private final String myPresented;

        SuspiciousToArrayCallFix(PsiType wantedType, boolean isFunction) {
            if (isFunction) {
                this.myReplacement = wantedType.getCanonicalText() + "[]::new";
                this.myPresented = wantedType.getPresentableText() + "[]::new";
            } else {
                String index = StringUtil.repeat((String)"[0]", (int)(wantedType.getArrayDimensions() + 1));
                PsiType componentType = wantedType.getDeepComponentType();
                this.myReplacement = "new " + componentType.getCanonicalText() + index;
                this.myPresented = "new " + componentType.getPresentableText() + index;
            }
        }

        @Override
        protected void doFix(Project project, ProblemDescriptor descriptor) {
            PsiExpression expression2 = (PsiExpression)ObjectUtils.tryCast((Object)descriptor.getStartElement(), PsiExpression.class);
            if (expression2 == null) {
                return;
            }
            new CommentTracker().replaceAndRestoreComments((PsiElement)expression2, this.myReplacement);
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{this.myPresented});
        }

        @Nls(capitalization=Nls.Capitalization.Sentence)
        @NotNull
        public String getFamilyName() {
            return InspectionGadgetsBundle.message("suspicious.to.array.call.fix.family.name", new Object[0]);
        }
    }

    private static class SuspiciousToArrayCallVisitor
    extends BaseInspectionVisitor {
        private SuspiciousToArrayCallVisitor() {
        }

        public void visitMethodCallExpression(@NotNull PsiMethodCallExpression expression2) {
            PsiType argumentType;
            super.visitMethodCallExpression(expression2);
            PsiReferenceExpression methodExpression = expression2.getMethodExpression();
            String methodName = methodExpression.getReferenceName();
            if (!"toArray".equals(methodName)) {
                return;
            }
            PsiExpression qualifierExpression2 = methodExpression.getQualifierExpression();
            if (qualifierExpression2 == null) {
                return;
            }
            PsiType type2 = qualifierExpression2.getType();
            if (!(type2 instanceof PsiClassType)) {
                return;
            }
            PsiExpressionList argumentList = expression2.getArgumentList();
            PsiExpression[] arguments = argumentList.getExpressions();
            if (arguments.length != 1) {
                return;
            }
            PsiExpression argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)arguments[0]);
            if (argument == null) {
                return;
            }
            PsiClassType classType = (PsiClassType)type2;
            PsiClass aClass = classType.resolve();
            if (aClass == null) {
                return;
            }
            if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.Collection")) {
                PsiType itemType = JavaGenericsUtil.getCollectionItemType((PsiType)classType, (GlobalSearchScope)expression2.getResolveScope());
                PsiType argumentType2 = argument.getType();
                if (!(argumentType2 instanceof PsiArrayType)) {
                    argumentType2 = SuspiciousToArrayCallVisitor.getIntFunctionParameterType(argument);
                }
                this.checkArrayTypes(argument, expression2, argumentType2, itemType);
            } else if (InheritanceUtil.isInheritor((PsiClass)aClass, (String)"java.util.stream.Stream") && (argumentType = SuspiciousToArrayCallVisitor.getIntFunctionParameterType(argument)) != null) {
                this.checkArrayTypes(argument, expression2, argumentType, StreamApiUtil.getStreamElementType((PsiType)classType, false));
            }
        }

        private static PsiType getIntFunctionParameterType(PsiExpression argument) {
            PsiType argumentType = FunctionalExpressionUtils.getFunctionalExpressionType(argument);
            return PsiUtil.substituteTypeParameter((PsiType)argumentType, (String)"java.util.function.IntFunction", (int)0, (boolean)false);
        }

        private void checkArrayTypes(@NotNull PsiExpression argument, @NotNull PsiMethodCallExpression expression2, PsiType argumentType, PsiType itemType) {
            if (!(argumentType instanceof PsiArrayType)) {
                return;
            }
            PsiArrayType arrayType = (PsiArrayType)argumentType;
            PsiType componentType = arrayType.getComponentType();
            PsiType actualType = SuspiciousToArrayCallVisitor.getActualItemTypeIfMismatch(arrayType, expression2, itemType);
            if (actualType != null) {
                this.registerError((PsiElement)argument, actualType, componentType, !(argument.getType() instanceof PsiArrayType));
            }
        }

        @Nullable
        private static PsiType getActualItemTypeIfMismatch(@NotNull PsiArrayType arrayType, @NotNull PsiMethodCallExpression expression2, PsiType itemType) {
            PsiClass aClass;
            itemType = GenericsUtil.getVariableTypeByExpressionType((PsiType)itemType);
            PsiType componentType = arrayType.getComponentType();
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
            if (parent instanceof PsiTypeCastExpression) {
                PsiTypeCastExpression castExpression = (PsiTypeCastExpression)parent;
                PsiTypeElement castTypeElement = castExpression.getCastType();
                if (castTypeElement == null) {
                    return null;
                }
                PsiType castType = castTypeElement.getType();
                if (castType.equals(arrayType) || !(castType instanceof PsiArrayType)) {
                    return null;
                }
                PsiArrayType castArrayType = (PsiArrayType)castType;
                PsiType type2 = castArrayType.getComponentType();
                if (JavaGenericsUtil.isReifiableType((PsiType)type2)) {
                    return type2;
                }
                return null;
            }
            if (itemType == null || componentType.isAssignableFrom(itemType)) {
                return null;
            }
            if (itemType instanceof PsiClassType && (aClass = ((PsiClassType)itemType).resolve()) instanceof PsiTypeParameter) {
                PsiReferenceList extendsList = ((PsiTypeParameter)aClass).getExtendsList();
                PsiClassType[] types = extendsList.getReferencedTypes();
                if (types.length == 0) {
                    return TypeUtils.getObjectType((PsiElement)expression2);
                }
                if (types.length == 1) {
                    return types[0];
                }
                return null;
            }
            return itemType;
        }
    }
}

