/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.RunnerResult;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.instructions.FinishElementInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.types.DfConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.DfaExpressionFactory;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.java.analysis.JavaAnalysisBundle;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiParameterListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.siyeh.ig.callMatcher.CallMatcher;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import one.util.streamex.EntryStream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SuspiciousInvocationHandlerImplementationInspection
extends AbstractBaseJavaLocalInspectionTool {
    private static final String HANDLER_CLASS = "java.lang.reflect.InvocationHandler";
    private static final String[] HANDLER_ARGUMENT_TYPES = new String[]{"java.lang.Object", "java.lang.reflect.Method", "java.lang.Object[]"};
    private static final CallMatcher INVOKE = CallMatcher.instanceCall("java.lang.reflect.InvocationHandler", "invoke").parameterTypes(HANDLER_ARGUMENT_TYPES);

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                Object[] parameters2;
                PsiParameterList list;
                if (INVOKE.methodMatches(method)) {
                    this.check((PsiParameterListOwner)method);
                }
                if (method.getReturnType() instanceof PsiClassType && (list = method.getParameterList()).getParametersCount() == 3 && EntryStream.zip((Object[])(parameters2 = list.getParameters()), (Object[])HANDLER_ARGUMENT_TYPES).allMatch((p, t) -> TypeUtils.typeEquals(t, p.getType())) && SyntaxTraverser.psiTraverser((PsiElement)holder.getFile()).filter(PsiMethodReferenceExpression.class).filter(ref -> ref.isReferenceTo((PsiElement)method) && TypeUtils.typeEquals(SuspiciousInvocationHandlerImplementationInspection.HANDLER_CLASS, ref.getFunctionalInterfaceType())).first() != null) {
                    this.check((PsiParameterListOwner)method);
                }
            }

            public void visitLambdaExpression(PsiLambdaExpression lambda2) {
                if (lambda2.getParameterList().getParametersCount() != 3) {
                    return;
                }
                PsiType type2 = lambda2.getFunctionalInterfaceType();
                if (!InheritanceUtil.isInheritor((PsiType)type2, (String)SuspiciousInvocationHandlerImplementationInspection.HANDLER_CLASS)) {
                    return;
                }
                this.check((PsiParameterListOwner)lambda2);
            }

            private void check(final PsiParameterListOwner method) {
                final PsiElement body2 = method.getBody();
                if (body2 == null) {
                    return;
                }
                PsiParameter methodParameter = method.getParameterList().getParameter(1);
                if (methodParameter == null) {
                    return;
                }
                if (body2 instanceof PsiCodeBlock && !ControlFlowUtils.containsReturn(body2)) {
                    return;
                }
                if (!VariableAccessUtils.variableIsUsed((PsiVariable)methodParameter, body2)) {
                    holder.registerProblem((PsiElement)Objects.requireNonNull(methodParameter.getNameIdentifier()), JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.method.unused.message", (Object[])new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                final InvocationHandlerAnalysisRunner runner = new InvocationHandlerAnalysisRunner(holder, body2, methodParameter);
                final DfaVariableValue methodName = runner.myDfaMethodName;
                if (methodName == null) {
                    return;
                }
                final TreeMap<String, Map> returnMap = new TreeMap<String, Map>();
                RunnerResult result = runner.analyzeMethod(body2, new StandardInstructionVisitor(){

                    @Override
                    protected void checkReturnValue(@NotNull DfaValue value2, @NotNull PsiExpression expression2, @NotNull PsiParameterListOwner context, @NotNull DfaMemoryState state) {
                        if (context != method) {
                            return;
                        }
                        String name2 = DfConstantType.getConstantOfType(state.getDfType(methodName), String.class);
                        if (name2 == null) {
                            runner.cancel();
                            return;
                        }
                        DfType type2 = state.getDfType(value2);
                        if (type2 instanceof DfPrimitiveType) {
                            type2 = DfTypes.typedObject((PsiType)((DfPrimitiveType)type2).getPsiType().getBoxedType(body2), Nullability.NOT_NULL);
                        }
                        returnMap.computeIfAbsent(name2, k -> new HashMap()).merge(expression2, type2, DfType::join);
                    }
                });
                if (result != RunnerResult.OK) {
                    return;
                }
                HashSet reportedAnchors = new HashSet();
                returnMap.forEach((name2, map2) -> {
                    DfType reduced = map2.values().stream().reduce(DfTypes.BOTTOM, DfType::join);
                    PsiType wantedType = this.getWantedType(body2, (String)name2);
                    if (wantedType == null) {
                        return;
                    }
                    TypeConstraint wantedConstraint = TypeConstraints.exact(wantedType);
                    if (reduced.meet(wantedConstraint.asDfType().meet(DfTypes.NOT_NULL_OBJECT)) != DfTypes.BOTTOM && DfaNullability.fromDfType(reduced) != DfaNullability.NULLABLE) {
                        return;
                    }
                    map2.forEach((expression2, type2) -> {
                        DfaNullability nullability;
                        if (reportedAnchors.contains(expression2)) {
                            return;
                        }
                        String message2 = null;
                        TypeConstraint constraint = TypeConstraint.fromDfType(type2);
                        if (wantedConstraint.meet(constraint) == TypeConstraints.BOTTOM) {
                            message2 = JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.type.mismatch.message", (Object[])new Object[]{name2, wantedConstraint.getPresentationText(null), constraint.getPresentationText(null)});
                        }
                        if ((nullability = DfaNullability.fromDfType(type2)) == DfaNullability.NULL) {
                            String string = message2 = name2.equals("toString") ? JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.null.returned.for.toString.message", (Object[])new Object[0]) : JavaAnalysisBundle.message((String)"suspicious.invocation.handler.implementation.null.returned.message", (Object[])new Object[]{name2});
                        }
                        if (message2 != null) {
                            reportedAnchors.add(expression2);
                            holder.registerProblem((PsiElement)expression2, message2, new LocalQuickFix[0]);
                        }
                    });
                });
            }

            @Nullable
            private PsiType getWantedType(PsiElement body2, String name2) {
                switch (name2) {
                    case "equals": {
                        return PsiType.BOOLEAN.getBoxedType(body2);
                    }
                    case "hashCode": {
                        return PsiType.INT.getBoxedType(body2);
                    }
                    case "toString": {
                        return PsiType.getJavaLangString((PsiManager)body2.getManager(), (GlobalSearchScope)body2.getResolveScope());
                    }
                }
                return null;
            }
        };
    }

    private static class InvocationHandlerAnalysisRunner
    extends DataFlowRunner {
        private final PsiElement myBody;
        private DfaVariableValue myDfaMethodName;
        private DfaVariableValue myDfaMethodDeclaringClass;
        private PsiType myStringType;
        private PsiType myObjectType;
        private PsiType myClassType;

        InvocationHandlerAnalysisRunner(@NotNull ProblemsHolder holder, PsiElement body2, PsiParameter methodParameter) {
            super(holder.getProject(), body2);
            this.myBody = body2;
            PsiClass methodClass = PsiUtil.resolveClassInClassTypeOnly((PsiType)methodParameter.getType());
            if (methodClass == null) {
                return;
            }
            PsiMethod[] getNameMethods = methodClass.findMethodsByName("getName", false);
            if (getNameMethods.length != 1) {
                return;
            }
            PsiMethod getNameMethod = getNameMethods[0];
            if (!getNameMethod.getParameterList().isEmpty()) {
                return;
            }
            PsiMethod[] getDeclaringClassMethods = methodClass.findMethodsByName("getDeclaringClass", false);
            if (getDeclaringClassMethods.length != 1) {
                return;
            }
            PsiMethod getDeclaringClassMethod = getDeclaringClassMethods[0];
            if (!getDeclaringClassMethod.getParameterList().isEmpty()) {
                return;
            }
            this.myClassType = getDeclaringClassMethod.getReturnType();
            this.myStringType = getNameMethod.getReturnType();
            this.myObjectType = PsiType.getJavaLangObject((PsiManager)methodClass.getManager(), (GlobalSearchScope)methodClass.getResolveScope());
            if (this.myClassType == null || this.myStringType == null) {
                return;
            }
            DfaValueFactory factory = this.getFactory();
            DfaVariableValue dfaMethod = factory.getVarFactory().createVariableValue((PsiVariable)methodParameter);
            this.myDfaMethodName = (DfaVariableValue)new DfaExpressionFactory.GetterDescriptor(getNameMethod).createValue(factory, dfaMethod);
            this.myDfaMethodDeclaringClass = (DfaVariableValue)new DfaExpressionFactory.GetterDescriptor(getDeclaringClassMethod).createValue(factory, dfaMethod);
        }

        @Override
        @NotNull
        protected List<DfaInstructionState> createInitialInstructionStates(@NotNull PsiElement psiBlock, @NotNull Collection<? extends DfaMemoryState> memStates, @NotNull ControlFlow flow) {
            if (psiBlock != this.myBody) {
                return super.createInitialInstructionStates(psiBlock, memStates, flow);
            }
            ArrayList<DfaInstructionState> result = new ArrayList<DfaInstructionState>();
            DfaValueFactory factory = this.getFactory();
            Instruction instruction = flow.getInstruction(0);
            for (Instruction inst : flow.getInstructions()) {
                if (!(inst instanceof FinishElementInstruction)) continue;
                Set<DfaVariableValue> flush = ((FinishElementInstruction)inst).getVarsToFlush();
                flush.remove(this.myDfaMethodDeclaringClass);
                flush.remove(this.myDfaMethodName);
                flush.remove(this.myDfaMethodName.getQualifier());
            }
            for (DfaMemoryState dfaMemoryState : memStates) {
                dfaMemoryState.applyCondition(this.myDfaMethodDeclaringClass.eq(factory.getConstant(this.myObjectType, this.myClassType)));
                for (String methodName : Arrays.asList("hashCode", "equals", "toString")) {
                    DfaMemoryState methodSpecificState = dfaMemoryState.createCopy();
                    methodSpecificState.applyCondition(this.myDfaMethodName.eq(factory.getConstant(methodName, this.myStringType)));
                    result.add(new DfaInstructionState(instruction, methodSpecificState));
                }
            }
            return result;
        }
    }
}

