/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.bugs;

import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.InspectionGadgetsBundle;
import com.siyeh.ig.BaseInspection;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CopyConstructorMissesFieldInspection
extends BaseInspection {
    @Override
    @NotNull
    protected String buildErrorString(Object ... infos) {
        List fields = (List)infos[0];
        if (fields.size() == 1) {
            return InspectionGadgetsBundle.message("copy.constructor.misses.field.problem.descriptor.1", ((PsiField)fields.get(0)).getName());
        }
        if (fields.size() == 2) {
            return InspectionGadgetsBundle.message("copy.constructor.misses.field.problem.descriptor.2", ((PsiField)fields.get(0)).getName(), ((PsiField)fields.get(1)).getName());
        }
        if (fields.size() == 3) {
            return InspectionGadgetsBundle.message("copy.constructor.misses.field.problem.descriptor.3", ((PsiField)fields.get(0)).getName(), ((PsiField)fields.get(1)).getName(), ((PsiField)fields.get(2)).getName());
        }
        return InspectionGadgetsBundle.message("copy.constructor.misses.field.problem.descriptor.many", fields.size());
    }

    @Override
    public BaseInspectionVisitor buildVisitor() {
        return new CopyConstructorMissesFieldVisitor();
    }

    private static class CopyConstructorMissesFieldVisitor
    extends BaseInspectionVisitor {
        private CopyConstructorMissesFieldVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            SmartList assignedFields;
            HashSet methodsOneLevelDeep;
            if (!MethodUtils.isCopyConstructor(method)) {
                return;
            }
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return;
            }
            List fields = Arrays.stream(aClass.getFields()).filter(f -> !f.hasModifierProperty("static") && !f.hasModifierProperty("transient") && (!f.hasModifierProperty("final") || f.getInitializer() == null)).collect(Collectors.toList());
            if (fields.isEmpty()) {
                return;
            }
            PsiParameter parameter2 = Objects.requireNonNull(method.getParameterList().getParameter(0));
            if (!PsiTreeUtil.processElements((PsiElement)method, arg_0 -> CopyConstructorMissesFieldVisitor.lambda$visitMethod$1(parameter2, methodsOneLevelDeep = new HashSet(), (List)(assignedFields = new SmartList()), arg_0))) {
                return;
            }
            for (PsiMethod calledMethod : methodsOneLevelDeep) {
                if (PsiTreeUtil.processElements((PsiElement)calledMethod, arg_0 -> CopyConstructorMissesFieldVisitor.lambda$visitMethod$2(parameter2, (List)assignedFields, arg_0))) continue;
                return;
            }
            for (PsiField assignedField : assignedFields) {
                if (aClass != PsiUtil.resolveClassInClassTypeOnly((PsiType)assignedField.getType())) continue;
                return;
            }
            fields.removeAll((Collection<?>)assignedFields);
            if (fields.isEmpty()) {
                return;
            }
            this.registerMethodError(method, fields);
        }

        private static boolean collectAssignedFields(PsiElement element, PsiParameter parameter2, @Nullable Set<? super PsiMethod> methods, List<? super PsiField> assignedFields) {
            if (element instanceof PsiAssignmentExpression) {
                PsiExpression lhs = PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiAssignmentExpression)element).getLExpression());
                PsiVariable variable = CopyConstructorMissesFieldVisitor.resolveVariable(lhs, null);
                if (variable instanceof PsiField) {
                    assignedFields.add((PsiField)((PsiField)variable));
                }
            } else if (JavaPsiConstructorUtil.isConstructorCall((PsiElement)element)) {
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                for (PsiExpression argument : methodCallExpression.getArgumentList().getExpressions()) {
                    PsiVariable variable = CopyConstructorMissesFieldVisitor.resolveVariable(argument = PsiUtil.skipParenthesizedExprDown((PsiExpression)argument), parameter2);
                    if (variable == parameter2) {
                        return false;
                    }
                    if (variable instanceof PsiField) {
                        assignedFields.add((PsiField)((PsiField)variable));
                    }
                    ContainerUtil.addIfNotNull(assignedFields, (Object)CopyConstructorMissesFieldVisitor.resolveFieldOfGetter(argument, parameter2));
                }
            } else if (element instanceof PsiMethodCallExpression) {
                PsiReferenceExpression referenceExpression;
                PsiElement target;
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)element;
                PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)methodCallExpression.getMethodExpression().getQualifierExpression());
                if (qualifier == null || qualifier instanceof PsiThisExpression) {
                    PsiMethod method = methodCallExpression.resolveMethod();
                    PsiField field = PropertyUtil.getFieldOfSetter(method);
                    if (field != null) {
                        assignedFields.add((PsiField)field);
                    } else if (methods != null && method != null) {
                        methods.add((PsiMethod)method);
                    }
                } else if (qualifier instanceof PsiReferenceExpression && (target = (referenceExpression = (PsiReferenceExpression)qualifier).resolve()) instanceof PsiField) {
                    assignedFields.add((PsiField)((PsiField)target));
                }
            }
            return true;
        }

        private static PsiVariable resolveVariable(PsiExpression expression2, PsiParameter requiredQualifier) {
            if (!(expression2 instanceof PsiReferenceExpression)) {
                return null;
            }
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)expression2;
            PsiExpression qualifier = PsiUtil.skipParenthesizedExprDown((PsiExpression)referenceExpression.getQualifierExpression());
            PsiElement target = referenceExpression.resolve();
            if (requiredQualifier == null) {
                if (qualifier != null && !(qualifier instanceof PsiThisExpression)) {
                    return null;
                }
            } else if (!ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)requiredQualifier)) {
                return target == requiredQualifier ? requiredQualifier : null;
            }
            return target instanceof PsiVariable ? (PsiVariable)target : null;
        }

        private static PsiField resolveFieldOfGetter(PsiExpression expression2, PsiParameter requiredQualifier) {
            if (!(expression2 instanceof PsiMethodCallExpression)) {
                return null;
            }
            PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
            PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
            if (!ExpressionUtils.isReferenceTo(qualifier, (PsiVariable)requiredQualifier)) {
                return null;
            }
            return PropertyUtil.getFieldOfGetter(methodCallExpression.resolveMethod());
        }

        private static /* synthetic */ boolean lambda$visitMethod$2(PsiParameter parameter2, List assignedFields, PsiElement e) {
            return CopyConstructorMissesFieldVisitor.collectAssignedFields(e, parameter2, null, assignedFields);
        }

        private static /* synthetic */ boolean lambda$visitMethod$1(PsiParameter parameter2, Set methodsOneLevelDeep, List assignedFields, PsiElement e) {
            return CopyConstructorMissesFieldVisitor.collectAssignedFields(e, parameter2, methodsOneLevelDeep, assignedFields);
        }
    }
}

