/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiType;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.ReferenceEditorWithBrowseButton;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.AbstractConvertContext;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.JvmPsiTypeConverterImpl;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.EditorTextFieldControl;
import com.intellij.util.xml.ui.PsiClassControl;
import com.intellij.util.xml.ui.PsiTypePanel;
import org.jetbrains.annotations.NotNull;

public class PsiTypeControl
extends EditorTextFieldControl<PsiTypePanel> {
    public PsiTypeControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper, commitOnEveryChange);
    }

    @NotNull
    protected String getValue() {
        String rawValue = super.getValue();
        try {
            PsiType psiType = JavaPsiFacade.getElementFactory((Project)this.getProject()).createTypeFromText(rawValue, null);
            String s = JvmPsiTypeConverterImpl.convertToString(psiType);
            if (s != null) {
                return s;
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            // empty catch block
        }
        return rawValue;
    }

    protected void setValue(String value2) {
        PsiType type2 = JvmPsiTypeConverterImpl.convertFromString(value2, (ConvertContext)new AbstractConvertContext(){

            @NotNull
            public DomElement getInvocationElement() {
                return PsiTypeControl.this.getDomElement();
            }
        });
        if (type2 != null) {
            value2 = type2.getCanonicalText();
        }
        super.setValue(value2);
    }

    protected EditorTextField getEditorTextField(@NotNull PsiTypePanel component) {
        return ((ReferenceEditorWithBrowseButton)component.getComponent(0)).getEditorTextField();
    }

    protected PsiTypePanel createMainComponent(PsiTypePanel boundedComponent, Project project) {
        if (boundedComponent == null) {
            boundedComponent = new PsiTypePanel();
        }
        return PsiClassControl.initReferenceEditorWithBrowseButton(boundedComponent, new ReferenceEditorWithBrowseButton(null, project, s -> JavaReferenceEditorUtil.createTypeDocument(s, project), ""), this);
    }
}

