/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testIntegration;

import com.intellij.execution.TestStateStorage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.testIntegration.DeadTestsCleaner;
import com.intellij.testIntegration.RecentTestRunnerImpl;
import com.intellij.testIntegration.RecentTestsListPopup;
import com.intellij.testIntegration.RecentTestsListProvider;
import com.intellij.testIntegration.RecentTestsPopupEntry;
import com.intellij.testIntegration.RunConfigurationByRecordProvider;
import com.intellij.testIntegration.SelectTestStep;
import com.intellij.testIntegration.TestLocator;
import com.intellij.testIntegration.UrlsCollector;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ShowRecentTests
extends AnAction {
    private static final int TEST_LIMIT = Integer.MAX_VALUE;
    private static final String ID = "show.recent.tests.action";

    private static Date getSinceDate() {
        return new Date(System.currentTimeMillis() - 86400000L);
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabled(e.getProject() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        TestStateStorage testStorage = TestStateStorage.getInstance((Project)project);
        TestLocator testLocator = new TestLocator(project);
        RecentTestRunnerImpl testRunner = new RecentTestRunnerImpl(testLocator);
        Map records = testStorage.getRecentTests(Integer.MAX_VALUE, ShowRecentTests.getSinceDate());
        RunConfigurationByRecordProvider configurationProvider = new RunConfigurationByRecordProvider(project);
        RecentTestsListProvider listProvider = new RecentTestsListProvider(configurationProvider, records);
        List<RecentTestsPopupEntry> entries = listProvider.getTestsToShow();
        SelectTestStep selectStepTest = new SelectTestStep("Debug Recent Tests", entries, testRunner);
        RecentTestsListPopup popup = new RecentTestsListPopup(project, (ListPopupStep<RecentTestsPopupEntry>)selectStepTest, testRunner, testLocator);
        popup.showCenteredInCurrentWindow(project);
        ShowRecentTests.cleanDeadTests(entries, testLocator, testStorage);
    }

    private static void cleanDeadTests(List<RecentTestsPopupEntry> entries, TestLocator testLocator, TestStateStorage testStorage) {
        UrlsCollector collector = new UrlsCollector();
        entries.forEach(e -> e.accept(collector));
        ApplicationManager.getApplication().executeOnPooledThread((Runnable)new DeadTestsCleaner(testStorage, collector.getUrls(), testLocator));
    }
}

