/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.inspections.Splitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiTypeTokenizer
extends Tokenizer<PsiTypeElement> {
    public void tokenize(@NotNull PsiTypeElement element, TokenConsumer consumer) {
        String elementText;
        boolean isInSource;
        PsiType type2 = element.getType();
        if (type2 instanceof PsiDisjunctionType) {
            this.tokenizeComplexType(element, consumer);
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type2);
        if (psiClass == null || psiClass.getContainingFile() == null || psiClass.getContainingFile().getVirtualFile() == null) {
            return;
        }
        String name2 = psiClass.getName();
        if (name2 == null) {
            return;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        boolean bl = isInSource = virtualFile != null && fileIndex.isInContent(virtualFile);
        if (isInSource && (elementText = element.getText()).contains(name2)) {
            consumer.consumeToken((PsiElement)element, elementText, true, 0, PsiTypeTokenizer.getRangeToCheck(elementText, name2), (Splitter)IdentifierSplitter.getInstance());
        }
    }

    private void tokenizeComplexType(PsiTypeElement element, TokenConsumer consumer) {
        List subTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, PsiTypeElement.class);
        for (PsiTypeElement subType : subTypes) {
            this.tokenize(subType, consumer);
        }
    }

    @NotNull
    private static TextRange getRangeToCheck(@NotNull String text2, @NotNull String name2) {
        int i = text2.indexOf(name2);
        return new TextRange(i, i + name2.length());
    }
}

