/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.execution.filters.ExceptionAnalysisProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ClassUtils;
import java.util.List;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class StackFilter {
    final int myExtraFrames;
    @NotNull
    final String myClassName;
    @NotNull
    final String myMethodName;
    @Nullable
    final String myFileName;
    @Nullable
    final StackFilter myNext;

    private StackFilter(int frames, @NotNull String className2, @NotNull String methodName, @Nullable String fileName, @Nullable StackFilter next) {
        this.myExtraFrames = frames;
        this.myClassName = className2;
        this.myMethodName = methodName;
        this.myFileName = fileName;
        this.myNext = next;
    }

    SearchScope correctScope(SearchScope base) {
        if (base instanceof GlobalSearchScope && this.myExtraFrames == 0 && this.myFileName != null) {
            return new DelegatingGlobalSearchScope((GlobalSearchScope)base){

                public boolean contains(@NotNull VirtualFile file) {
                    return file.getName().equals(StackFilter.this.myFileName) && super.contains(file);
                }
            };
        }
        return base;
    }

    boolean isAcceptable(PsiElement element) {
        if (this.myExtraFrames > 0) {
            return true;
        }
        PsiElement parent = StackFilter.getElementContext(element);
        if (parent instanceof PsiMember) {
            return this.myMethodName.equals(StackFilter.getExpectedName((PsiMember)parent)) && this.classMatches(((PsiMember)parent).getContainingClass());
        }
        if (parent instanceof PsiLambdaExpression) {
            return this.myMethodName.startsWith("lambda$") && this.classMatches(ClassUtils.getContainingClass(parent));
        }
        return false;
    }

    static PsiElement getElementContext(PsiElement element) {
        PsiElement parent;
        while ((parent = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiMember.class, PsiLambdaExpression.class})) instanceof PsiAnonymousClass && PsiTreeUtil.isAncestor((PsiElement)((PsiAnonymousClass)parent).getArgumentList(), (PsiElement)element, (boolean)true)) {
            element = parent;
        }
        return parent;
    }

    @Nullable
    private static String getExpectedName(PsiMember member) {
        if (member instanceof PsiMethod) {
            return ((PsiMethod)member).isConstructor() ? "<init>" : member.getName();
        }
        if (member instanceof PsiField || member instanceof PsiClassInitializer) {
            return member.hasModifierProperty("static") ? "<clinit>" : "<init>";
        }
        return null;
    }

    private boolean classMatches(PsiClass aClass) {
        if (aClass == null) {
            return false;
        }
        PsiFile file = aClass.getContainingFile();
        if (!(file instanceof PsiClassOwner)) {
            return false;
        }
        String packageName = StringUtil.getPackageName((String)this.myClassName);
        if (!((PsiClassOwner)file).getPackageName().matches(packageName)) {
            return false;
        }
        String shortName = StringUtil.getShortName((String)this.myClassName);
        return StackFilter.classNameMatches(aClass, shortName);
    }

    private static boolean classNameMatches(PsiClass aClass, String shortName) {
        String actualName = aClass.getName();
        if (shortName.equals(actualName)) {
            return true;
        }
        String afterDollar = StringUtil.getShortName((String)shortName, (char)'$');
        if (actualName != null ? !actualName.equals(afterDollar) : !afterDollar.matches("\\d+")) {
            return false;
        }
        PsiClass containingClass = ClassUtils.getContainingClass((PsiElement)aClass);
        String prefix = StringUtil.substringBefore((String)shortName, (String)"$");
        if (prefix == null) {
            return containingClass == null;
        }
        return containingClass != null && StackFilter.classNameMatches(containingClass, prefix);
    }

    @NotNull
    StackFilter pushFrame() {
        return new StackFilter(this.myExtraFrames + 1, this.myClassName, this.myMethodName, this.myFileName, this.myNext);
    }

    @Nullable
    StackFilter popFrame(Project project) {
        if (this.myExtraFrames == 0) {
            PsiClass psiClass;
            if (this.myNext != null && this.myClassName.equals(this.myNext.myClassName) && this.myMethodName.equals(this.myNext.myMethodName) && Objects.equals(this.myFileName, this.myNext.myFileName) && (psiClass = ClassUtil.findPsiClass((PsiManager)PsiManager.getInstance((Project)project), (String)this.myClassName, null, (boolean)true)) != null) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = psiClass.findMethodsByName(this.myMethodName, false)) {
                    if (!StackFilter.isBridge(method)) continue;
                    return this.myNext.myNext;
                }
            }
            return this.myNext;
        }
        return new StackFilter(this.myExtraFrames - 1, this.myClassName, this.myMethodName, this.myFileName, this.myNext);
    }

    private static boolean isBridge(PsiMethod method) {
        PsiMethod[] superMethods = method.findSuperMethods();
        if (superMethods.length == 0) {
            return false;
        }
        PsiType returnType = TypeConversionUtil.erasure((PsiType)method.getReturnType());
        List parameterTypes = ContainerUtil.map((Object[])method.getParameterList().getParameters(), p -> TypeConversionUtil.erasure((PsiType)p.getType()));
        for (PsiMethod superMethod : superMethods) {
            if (!Objects.equals(returnType, TypeConversionUtil.erasure((PsiType)superMethod.getReturnType()))) {
                return true;
            }
            PsiParameter[] parameters2 = superMethod.getParameterList().getParameters();
            if (parameters2.length != parameterTypes.size()) continue;
            for (int i = 0; i < parameters2.length; ++i) {
                if (Objects.equals(TypeConversionUtil.erasure((PsiType)parameters2[i].getType()), parameterTypes.get(i))) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    static StackFilter from(List<ExceptionAnalysisProvider.StackLine> list) {
        return (StackFilter)StreamEx.of(list).foldRight(null, (line, prev) -> new StackFilter(0, line.getClassName(), line.getMethodName(), line.getFileName(), (StackFilter)prev));
    }

    public String toString() {
        return (this.myExtraFrames == 0 ? "" : this.myExtraFrames + "+") + this.myClassName + "." + this.myMethodName;
    }
}

