/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.slicer;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiUtil;
import com.intellij.slicer.JavaSliceBuilder;
import com.intellij.slicer.JavaValueFilter;
import com.intellij.slicer.SliceAnalysisParams;
import com.intellij.slicer.SliceForwardUtil;
import com.intellij.slicer.SliceUsage;
import com.intellij.slicer.SliceUtil;
import com.intellij.util.Processor;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class JavaSliceUsage
extends SliceUsage {
    private final PsiSubstitutor mySubstitutor;
    final int indexNesting;
    @NotNull
    final String syntheticField;
    final boolean requiresAssertionViolation;

    JavaSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull PsiSubstitutor substitutor) {
        this(element, parent, parent.params, substitutor, 0, "");
    }

    JavaSliceUsage(@NotNull PsiElement element, @NotNull SliceUsage parent, @NotNull SliceAnalysisParams params, @NotNull PsiSubstitutor substitutor, int indexNesting, @NotNull String syntheticField) {
        super(JavaSliceUsage.simplify(element), parent, params);
        this.mySubstitutor = substitutor;
        this.syntheticField = syntheticField;
        this.indexNesting = indexNesting;
        this.requiresAssertionViolation = params.valueFilter instanceof JavaValueFilter && ((JavaValueFilter)params.valueFilter).requiresAssertionViolation(this.getJavaElement());
    }

    @NotNull
    static PsiElement simplify(PsiElement element) {
        PsiExpression stripped;
        if (element instanceof PsiExpression && (stripped = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiExpression)element))) != null) {
            return stripped;
        }
        return element;
    }

    private JavaSliceUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        super(element, params);
        this.mySubstitutor = PsiSubstitutor.EMPTY;
        this.indexNesting = 0;
        this.syntheticField = "";
        this.requiresAssertionViolation = false;
    }

    @NotNull
    public static JavaSliceUsage createRootUsage(@NotNull PsiElement element, @NotNull SliceAnalysisParams params) {
        return new JavaSliceUsage(element, params);
    }

    protected void processUsagesFlownFromThe(PsiElement element, Processor<? super SliceUsage> uniqueProcessor) {
        SliceForwardUtil.processUsagesFlownFromThe(element, this, uniqueProcessor);
    }

    protected void processUsagesFlownDownTo(PsiElement element, Processor<? super SliceUsage> uniqueProcessor) {
        SliceUtil.processUsagesFlownDownTo(element, uniqueProcessor, JavaSliceBuilder.create(this));
    }

    @NotNull
    protected SliceUsage copy() {
        PsiElement element = this.getJavaElement();
        return this.getParent() == null ? JavaSliceUsage.createRootUsage(element, this.params) : new JavaSliceUsage(element, this.getParent(), this.params, this.mySubstitutor, this.indexNesting, this.syntheticField);
    }

    @NotNull
    PsiElement getJavaElement() {
        return Objects.requireNonNull(this.getUsageInfo().getElement());
    }

    @NotNull
    public PsiSubstitutor getSubstitutor() {
        return this.mySubstitutor;
    }

    public boolean canBeLeaf() {
        return this.indexNesting == 0 && super.canBeLeaf();
    }
}

