/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.wrapreturnvalue;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class ReturnValueBeanBuilder {
    private final List<PsiTypeParameter> myTypeParams = new ArrayList<PsiTypeParameter>();
    private String myClassName;
    private String myPackageName;
    private Project myProject;
    private PsiFile myFile;
    private PsiType myValueType;
    private boolean myStatic;

    ReturnValueBeanBuilder() {
    }

    public void setClassName(String className2) {
        this.myClassName = className2;
    }

    public void setPackageName(String packageName) {
        this.myPackageName = packageName;
    }

    public void setTypeArguments(List<? extends PsiTypeParameter> typeParams) {
        this.myTypeParams.clear();
        this.myTypeParams.addAll(typeParams);
    }

    public void setProject(Project project) {
        this.myProject = project;
    }

    public void setFile(@NotNull PsiFile file) {
        this.myFile = file;
    }

    public void setValueType(PsiType valueType) {
        this.myValueType = valueType;
    }

    public void setStatic(boolean isStatic) {
        this.myStatic = isStatic;
    }

    public String buildBeanClass() throws IOException {
        StringBuilder out = new StringBuilder(1024);
        if (this.myPackageName.length() > 0) {
            out.append("package ").append(this.myPackageName).append(";\n\n");
        }
        out.append("public ");
        if (this.myStatic) {
            out.append("static ");
        }
        out.append("class ").append(this.myClassName);
        if (!this.myTypeParams.isEmpty()) {
            out.append('<');
            boolean first = true;
            for (PsiTypeParameter typeParam : this.myTypeParams) {
                if (!first) {
                    out.append(',');
                }
                String parameterText = typeParam.getText();
                out.append(parameterText);
                first = false;
            }
            out.append('>');
        }
        out.append(" {\n");
        this.outputField(out);
        out.append("\n\n");
        this.outputConstructor(out);
        out.append("\n\n");
        this.outputGetter(out);
        out.append("\n}\n");
        return out.toString();
    }

    private void outputField(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(false);
        out.append("\tprivate final ").append(typeText).append(' ').append(this.getFieldName("value")).append(";");
    }

    private void outputConstructor(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(true);
        String name2 = "value";
        String parameterName = JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName("value", VariableKind.PARAMETER);
        String fieldName = this.getFieldName("value");
        out.append("\tpublic ").append(this.myClassName).append('(');
        out.append(((JavaCodeStyleSettings)this.getSettings().getCustomSettings(JavaCodeStyleSettings.class)).GENERATE_FINAL_PARAMETERS ? "final " : "");
        out.append(typeText).append(' ').append(parameterName);
        out.append(") {\n");
        if (fieldName.equals(parameterName)) {
            out.append("\t\tthis.").append(fieldName).append(" = ").append(parameterName).append(";\n");
        } else {
            out.append("\t\t").append(fieldName).append(" = ").append(parameterName).append(";\n");
        }
        out.append("\t}");
    }

    private CodeStyleSettings getSettings() {
        return this.myFile != null ? CodeStyle.getSettings((PsiFile)this.myFile) : CodeStyle.getProjectOrDefaultSettings((Project)this.myProject);
    }

    private void outputGetter(StringBuilder out) {
        String typeText = this.myValueType.getCanonicalText(true);
        String name2 = "value";
        String capitalizedName = StringUtil.capitalize((String)"value");
        String fieldName = this.getFieldName("value");
        out.append("\tpublic ").append(typeText).append(" get").append(capitalizedName).append("() {\n");
        out.append("\t\treturn ").append(fieldName).append(";\n");
        out.append("\t}");
    }

    private String getFieldName(String name2) {
        return JavaCodeStyleManager.getInstance((Project)this.myProject).propertyNameToVariableName(name2, VariableKind.FIELD);
    }
}

