/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import org.jetbrains.annotations.NotNull;

public class LocalVariableOccurrenceManager
extends BaseOccurrenceManager {
    private final PsiLocalVariable myLocalVariable;

    public LocalVariableOccurrenceManager(PsiLocalVariable localVariable, OccurrenceFilter filter) {
        super(filter);
        this.myLocalVariable = localVariable;
    }

    @Override
    public PsiExpression @NotNull [] defaultOccurrences() {
        return PsiExpression.EMPTY_ARRAY;
    }

    @Override
    public PsiExpression @NotNull [] findOccurrences() {
        return CodeInsightUtil.findReferenceExpressions(RefactoringUtil.getVariableScope(this.myLocalVariable), (PsiElement)this.myLocalVariable);
    }
}

