/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.rules.guava;

import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.BaseGuavaTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.FluentIterableConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaConversionUtil;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaOptionalConversionRule;
import com.intellij.refactoring.typeMigration.rules.guava.GuavaTypeConversionDescriptor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.controlflow.DoubleNegationInspection;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuavaFluentIterableConversionRule
extends BaseGuavaTypeConversionRule {
    private static final Logger LOG = Logger.getInstance(GuavaFluentIterableConversionRule.class);
    private static final Map<String, TypeConversionDescriptorFactory> DESCRIPTORS_MAP = new HashMap<String, TypeConversionDescriptorFactory>();
    public static final Set<String> CHAIN_HEAD_METHODS = ContainerUtil.newHashSet((Object[])new String[]{"from", "of", "fromNullable"});
    public static final String FLUENT_ITERABLE = "com.google.common.collect.FluentIterable";
    public static final String STREAM_COLLECT_TO_LIST = "$it$.collect(java.util.stream.Collectors.toList())";

    @Override
    protected boolean isValidMethodQualifierToConvert(PsiClass aClass) {
        return super.isValidMethodQualifierToConvert(aClass) || aClass != null && "com.google.common.base.Optional".equals(aClass.getQualifiedName());
    }

    @Override
    @Nullable
    protected TypeConversionDescriptorBase findConversionForMethod(@NotNull PsiType from, @NotNull PsiType to, @NotNull PsiMethod method, @NotNull String methodName, PsiExpression context, TypeMigrationLabeler labeler) {
        if (context instanceof PsiMethodCallExpression) {
            return GuavaFluentIterableConversionRule.buildCompoundDescriptor((PsiMethodCallExpression)context, to, labeler);
        }
        return GuavaFluentIterableConversionRule.getOneMethodDescriptor(methodName, method, from, context);
    }

    @Nullable
    private static TypeConversionDescriptorBase getOneMethodDescriptor(@NotNull String methodName, @NotNull PsiMethod method, @NotNull PsiType from, @Nullable PsiExpression context) {
        TypeConversionDescriptor descriptorBase = null;
        PsiType conversionType = null;
        boolean needSpecifyType = true;
        if (methodName.equals("of")) {
            descriptorBase = new TypeConversionDescriptor("'_FluentIterable?.of($arr$)", "java.util.Arrays.stream($arr$)");
        } else if (methodName.equals("from")) {
            descriptorBase = new TypeConversionDescriptor("'_FluentIterable?.from($it$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
                    PsiExpression argument = PseudoLambdaReplaceTemplate.replaceTypeParameters(methodCall.getArgumentList().getExpressions()[0]);
                    if (argument == null) {
                        return expression2;
                    }
                    boolean isCollection = InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)argument.getType()), (String)"java.util.Collection");
                    this.setReplaceByString(isCollection ? "($it$).stream()" : "java.util.stream.StreamSupport.stream(($it$).spliterator(), false)");
                    PsiExpression replaced = super.replace(expression2, evaluator);
                    ParenthesesUtils.removeParentheses(replaced, false);
                    return replaced;
                }
            };
        } else if (methodName.equals("filter")) {
            descriptorBase = FluentIterableConversionUtil.getFilterDescriptor(method, context);
        } else if (methodName.equals("isEmpty")) {
            descriptorBase = new TypeConversionDescriptor("$q$.isEmpty()", null){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                    PsiElement parent = expression2.getParent();
                    boolean isDoubleNegation = false;
                    if (parent instanceof PsiExpression && DoubleNegationInspection.isNegation((PsiExpression)parent)) {
                        isDoubleNegation = true;
                        expression2 = (PsiExpression)parent.replace((PsiElement)expression2);
                    }
                    this.setReplaceByString((isDoubleNegation ? "" : "!") + "$q$.findAny().isPresent()");
                    return super.replace(expression2, evaluator);
                }
            };
            needSpecifyType = false;
        } else if (methodName.equals("transformAndConcat")) {
            descriptorBase = new FluentIterableConversionUtil.TransformAndConcatConversionRule(context);
        } else if (methodName.equals("toArray")) {
            descriptorBase = FluentIterableConversionUtil.getToArrayDescriptor(from, context);
            needSpecifyType = false;
        } else if (methodName.equals("copyInto")) {
            descriptorBase = new FluentIterableConversionUtil.CopyIntoConversionDescriptor();
            needSpecifyType = false;
        } else if (methodName.equals("append")) {
            descriptorBase = GuavaFluentIterableConversionRule.createDescriptorForAppend(method, context);
        } else if (methodName.equals("get")) {
            descriptorBase = new TypeConversionDescriptor("$it$.get($p$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                    Object value2;
                    PsiMethodCallExpression methodCall = (PsiMethodCallExpression)expression2;
                    PsiExpression[] arguments = methodCall.getArgumentList().getExpressions();
                    this.setReplaceByString("$it$.skip($p$).findFirst().get()");
                    if (arguments.length == 1 && arguments[0] instanceof PsiLiteralExpression && (value2 = ((PsiLiteralExpression)arguments[0]).getValue()) != null && value2.equals(0)) {
                        this.setReplaceByString("$it$.findFirst().get()");
                    }
                    return super.replace(expression2, evaluator);
                }
            };
            needSpecifyType = false;
        } else if (methodName.equals("contains")) {
            descriptorBase = new TypeConversionDescriptor("$it$.contains($o$)", null){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                    PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)expression2;
                    PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
                    LOG.assertTrue(qualifier != null);
                    PsiClassType qualifierType = (PsiClassType)qualifier.getType();
                    LOG.assertTrue(qualifierType != null);
                    PsiType[] parameters2 = qualifierType.getParameters();
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
                    SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, null, null, parameters2.length == 1 ? parameters2[0] : null, false);
                    String suggestedName = codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)expression2, (boolean)false).names[0];
                    this.setReplaceByString("$it$.anyMatch(" + suggestedName + " -> java.util.Objects.equals(" + suggestedName + ", $o$))");
                    return super.replace(expression2, evaluator);
                }
            };
            needSpecifyType = false;
        } else if (methodName.equals("last")) {
            descriptorBase = new TypeConversionDescriptor("$it$.last()", null){

                @Override
                public PsiExpression replace(PsiExpression expression2, @NotNull TypeEvaluator evaluator) {
                    JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)expression2.getProject());
                    String varA = this.suggestName("a", codeStyleManager, (PsiElement)expression2);
                    String varB = this.suggestName("b", codeStyleManager, (PsiElement)expression2);
                    this.setReplaceByString("$it$.reduce((" + varA + ", " + varB + ") -> " + varB + ")");
                    return super.replace(expression2, evaluator);
                }

                private String suggestName(String baseName, JavaCodeStyleManager codeStyleManager, PsiElement place) {
                    SuggestedNameInfo suggestedNameInfo = codeStyleManager.suggestVariableName(VariableKind.LOCAL_VARIABLE, baseName, null, null, false);
                    return codeStyleManager.suggestUniqueVariableName((SuggestedNameInfo)suggestedNameInfo, (PsiElement)place, (boolean)false).names[0];
                }
            };
        } else {
            TypeConversionDescriptorFactory base = DESCRIPTORS_MAP.get(methodName);
            if (base != null) {
                TypeConversionDescriptor descriptor = base.create(context);
                needSpecifyType = base.isChainedMethod();
                if (needSpecifyType && !base.isFluentIterableReturnType()) {
                    conversionType = GuavaConversionUtil.addTypeParameters("java.util.Optional", context.getType(), (PsiElement)context);
                }
                descriptorBase = descriptor;
            }
        }
        if (descriptorBase == null) {
            return FluentIterableConversionUtil.createToCollectionDescriptor(methodName, context);
        }
        if (needSpecifyType) {
            if (conversionType == null) {
                PsiMethodCallExpression methodCall = (PsiMethodCallExpression)(context instanceof PsiMethodCallExpression ? context : context.getParent());
                conversionType = GuavaConversionUtil.addTypeParameters(GuavaTypeConversionDescriptor.isIterable((PsiExpression)methodCall) ? "java.lang.Iterable" : "java.util.stream.Stream", context.getType(), (PsiElement)context);
            }
            descriptorBase.withConversionType(conversionType);
        }
        return descriptorBase;
    }

    @Nullable
    private static TypeConversionDescriptor createDescriptorForAppend(PsiMethod method, PsiExpression context) {
        PsiClass psiClass;
        LOG.assertTrue("append".equals(method.getName()));
        PsiParameterList list = method.getParameterList();
        if (list.getParametersCount() != 1) {
            return null;
        }
        PsiType parameterType = list.getParameters()[0].getType();
        if (parameterType instanceof PsiEllipsisType) {
            return new TypeConversionDescriptor("$q$.append('_params*)", "java.util.stream.Stream.concat($q$, java.util.Arrays.asList($params$).stream())");
        }
        if (parameterType instanceof PsiClassType && (psiClass = PsiTypesUtil.getPsiClass((PsiType)parameterType)) != null && "java.lang.Iterable".equals(psiClass.getQualifiedName())) {
            PsiMethodCallExpression methodCall = (PsiMethodCallExpression)(context instanceof PsiMethodCallExpression ? context : context.getParent());
            PsiExpression expression2 = methodCall.getArgumentList().getExpressions()[0];
            boolean isCollection = InheritanceUtil.isInheritor((PsiClass)PsiTypesUtil.getPsiClass((PsiType)expression2.getType()), (String)"java.util.Collection");
            String argTemplate = isCollection ? "$arg$.stream()" : "java.util.stream.StreamSupport.stream($arg$.spliterator(), false)";
            return new TypeConversionDescriptor("$q$.append($arg$)", "java.util.stream.Stream.concat($q$," + argTemplate + ")");
        }
        return null;
    }

    @Nullable
    public static GuavaChainedConversionDescriptor buildCompoundDescriptor(PsiMethodCallExpression expression2, PsiType to, TypeMigrationLabeler labeler) {
        PsiMethod method;
        SmartList methodDescriptors = new SmartList();
        NotNullLazyValue<TypeConversionRule> optionalDescriptor = new NotNullLazyValue<TypeConversionRule>(){

            @NotNull
            protected TypeConversionRule compute() {
                for (TypeConversionRule rule : (TypeConversionRule[])TypeConversionRule.EP_NAME.getExtensions()) {
                    if (!(rule instanceof GuavaOptionalConversionRule)) continue;
                    return rule;
                }
                throw new RuntimeException("GuavaOptionalConversionRule extension is not found");
            }
        };
        PsiMethodCallExpression current = expression2;
        while ((method = current.resolveMethod()) != null) {
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) break;
            TypeConversionDescriptorBase descriptor = null;
            if (FLUENT_ITERABLE.equals(containingClass.getQualifiedName()) ? (descriptor = GuavaFluentIterableConversionRule.getOneMethodDescriptor(methodName, method, current.getType(), (PsiExpression)current)) == null : "com.google.common.base.Optional".equals(containingClass.getQualifiedName()) && (descriptor = ((TypeConversionRule)optionalDescriptor.getValue()).findConversion(null, null, (PsiMember)method, (PsiExpression)current.getMethodExpression(), labeler)) == null) {
                return null;
            }
            if (descriptor == null) {
                GuavaFluentIterableConversionRule.addToMigrateChainQualifier(labeler, (PsiExpression)current);
                break;
            }
            methodDescriptors.add(descriptor);
            PsiExpression qualifier = current.getMethodExpression().getQualifierExpression();
            if (qualifier instanceof PsiMethodCallExpression) {
                current = (PsiMethodCallExpression)qualifier;
                continue;
            }
            if (method.hasModifierProperty("static")) {
                if (!CHAIN_HEAD_METHODS.contains(methodName)) {
                    return null;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass != null && (FLUENT_ITERABLE.equals(aClass.getQualifiedName()) || "com.google.common.base.Optional".equals(aClass.getQualifiedName()))) break;
                return null;
            }
            if (qualifier instanceof PsiReferenceExpression && ((PsiReferenceExpression)qualifier).resolve() instanceof PsiVariable) {
                GuavaFluentIterableConversionRule.addToMigrateChainQualifier(labeler, qualifier);
                break;
            }
            return null;
        }
        return new GuavaChainedConversionDescriptor((List)methodDescriptors, to);
    }

    private static void addToMigrateChainQualifier(TypeMigrationLabeler labeler, PsiExpression qualifier) {
        boolean isFluentIterable;
        PsiClass qClass = PsiTypesUtil.getPsiClass((PsiType)qualifier.getType());
        if (qClass != null && ((isFluentIterable = FLUENT_ITERABLE.equals(qClass.getQualifiedName())) || "com.google.common.base.Optional".equals(qClass.getQualifiedName()))) {
            labeler.migrateExpressionType(qualifier, GuavaConversionUtil.addTypeParameters(isFluentIterable ? "java.util.stream.Stream" : "java.util.Optional", qualifier.getType(), (PsiElement)qualifier), qualifier.getParent(), false, false);
        }
    }

    @Override
    @NotNull
    public String ruleFromClass() {
        return FLUENT_ITERABLE;
    }

    @Override
    @NotNull
    public String ruleToClass() {
        return "java.util.stream.Stream";
    }

    @Override
    protected TypeConversionDescriptorBase getUnknownMethodConversion() {
        return null;
    }

    static {
        DESCRIPTORS_MAP.put("skip", new TypeConversionDescriptorFactory("$q$.skip($p$)", "$q$.skip($p$)", false, true, true));
        DESCRIPTORS_MAP.put("limit", new TypeConversionDescriptorFactory("$q$.limit($p$)", "$q$.limit($p$)", false, true, true));
        DESCRIPTORS_MAP.put("first", new TypeConversionDescriptorFactory("$q$.first()", "$q$.findFirst()", false, true, false));
        DESCRIPTORS_MAP.put("transform", new TypeConversionDescriptorFactory("$q$.transform($params$)", "$q$.map($params$)", true, true, true));
        DESCRIPTORS_MAP.put("allMatch", new TypeConversionDescriptorFactory("$it$.allMatch($c$)", "$it$.allMatch($c$)", true));
        DESCRIPTORS_MAP.put("anyMatch", new TypeConversionDescriptorFactory("$it$.anyMatch($c$)", "$it$.anyMatch($c$)", true));
        DESCRIPTORS_MAP.put("firstMatch", new TypeConversionDescriptorFactory("$it$.firstMatch($p$)", "$it$.filter($p$).findFirst()", true, true, false));
        DESCRIPTORS_MAP.put("size", new TypeConversionDescriptorFactory("$it$.size()", "(int) $it$.count()", false));
    }

    private static class GuavaChainedConversionDescriptor
    extends TypeConversionDescriptorBase {
        private final List<TypeConversionDescriptorBase> myMethodDescriptors;
        private final PsiType myToType;

        private GuavaChainedConversionDescriptor(List<TypeConversionDescriptorBase> descriptors, PsiType to) {
            this.myMethodDescriptors = new ArrayList<TypeConversionDescriptorBase>(descriptors);
            Collections.reverse(this.myMethodDescriptors);
            this.myToType = to;
        }

        @Override
        public PsiExpression replace(@NotNull PsiExpression expression2, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
            Stack methodChainStack = new Stack();
            PsiMethodCallExpression current = (PsiMethodCallExpression)expression2;
            while (current != null) {
                methodChainStack.add((Object)current);
                PsiExpression qualifier = current.getMethodExpression().getQualifierExpression();
                current = qualifier instanceof PsiMethodCallExpression ? (PsiMethodCallExpression)qualifier : null;
            }
            if (methodChainStack.size() != this.myMethodDescriptors.size()) {
                return expression2;
            }
            PsiExpression converted = null;
            for (TypeConversionDescriptorBase descriptor : this.myMethodDescriptors) {
                PsiMethodCallExpression toConvert = (PsiMethodCallExpression)methodChainStack.pop();
                converted = descriptor.replace((PsiExpression)toConvert, evaluator);
            }
            return converted;
        }

        @Override
        @Nullable
        public PsiType conversionType() {
            return this.myToType;
        }
    }

    static class TypeConversionDescriptorFactory {
        private final String myStringToReplace;
        private final String myReplaceByString;
        private final boolean myWithLambdaParameter;
        private final boolean myChainedMethod;
        private final boolean myFluentIterableReturnType;

        TypeConversionDescriptorFactory(String stringToReplace, String replaceByString, boolean withLambdaParameter) {
            this(stringToReplace, replaceByString, withLambdaParameter, false, false);
        }

        TypeConversionDescriptorFactory(@NonNls String stringToReplace, @NonNls String replaceByString, boolean withLambdaParameter, boolean chainedMethod, boolean fluentIterableReturnType) {
            this.myStringToReplace = stringToReplace;
            this.myReplaceByString = replaceByString;
            this.myWithLambdaParameter = withLambdaParameter;
            this.myChainedMethod = chainedMethod;
            this.myFluentIterableReturnType = fluentIterableReturnType;
        }

        public TypeConversionDescriptor create(PsiExpression context) {
            GuavaTypeConversionDescriptor descriptor = new GuavaTypeConversionDescriptor(this.myStringToReplace, this.myReplaceByString, context);
            if (!this.myWithLambdaParameter) {
                descriptor = descriptor.setConvertParameterAsLambda(false);
            }
            return descriptor;
        }

        public boolean isChainedMethod() {
            return this.myChainedMethod;
        }

        public boolean isFluentIterableReturnType() {
            return this.myFluentIterableReturnType;
        }
    }
}

