/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.rename.naming.AutomaticOverloadsRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class AutomaticOverloadsRenamerFactory
implements AutomaticRenamerFactory {
    public boolean isApplicable(@NotNull PsiElement element) {
        if (element.getLanguage() == JavaLanguage.INSTANCE && element instanceof PsiMethod && !((PsiMethod)element).isConstructor()) {
            PsiClass containingClass = ((PsiMethod)element).getContainingClass();
            return containingClass != null && containingClass.findMethodsByName(((PsiMethod)element).getName(), false).length > 1;
        }
        return false;
    }

    public String getOptionName() {
        return JavaRefactoringBundle.message((String)"rename.overloads", (Object[])new Object[0]);
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameOverloads();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameOverloads(enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(PsiElement element, String newName, Collection<UsageInfo> usages) {
        return new AutomaticOverloadsRenamer((PsiMethod)element, newName);
    }
}

