/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.PlainDirectoryRenameHandler;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiDirectoryProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

public class RenameModuleAndDirectoryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameModuleAndDirectoryHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        LOG.error("Must not be called");
    }

    public String getActionTitle() {
        return JavaRefactoringBundle.message((String)"rename.module.directory.title", (Object[])new Object[0]);
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        if (module == null) {
            return false;
        }
        PsiElement element = PsiElementRenameHandler.getElement((DataContext)dataContext);
        if (!(element instanceof PsiDirectory)) {
            return false;
        }
        PsiDirectory directory = (PsiDirectory)element;
        if (directory.getVirtualFile().equals(directory.getProject().getBaseDir())) {
            return false;
        }
        if (!PlainDirectoryRenameHandler.isPlainDirectory((PsiDirectory)directory)) {
            return false;
        }
        if (RenamePsiElementProcessor.forElement((PsiElement)directory).getClass() != RenamePsiDirectoryProcessor.class) {
            return false;
        }
        return module.getName().equals(directory.getName());
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext);
        LOG.assertTrue(module != null);
        PsiElement element = elements.length == 1 ? elements[0] : PsiElementRenameHandler.getElement((DataContext)dataContext);
        LOG.assertTrue(element != null);
        PsiElementRenameHandler.rename((PsiElement)element, (Project)project, (PsiElement)element, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)((String)dataContext.getData(PsiElementRenameHandler.DEFAULT_NAME)), (RenamePsiElementProcessor)new RenameModuleAndDirectoryProcessor(module));
    }

    private static void checkRenameModule(@NotNull Module module, @NotNull String newName) throws ConfigurationException {
        ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)module.getProject()).getModifiableModel();
        try {
            modifiableModel.renameModule(module, newName);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            throw new ConfigurationException(IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{newName}));
        }
    }

    private static void renameModule(@NotNull Module module, @NotNull String newName) {
        if (!module.isDisposed()) {
            try {
                ModifiableModuleModel model = ModuleManager.getInstance((Project)module.getProject()).getModifiableModel();
                model.renameModule(module, newName);
                model.commit();
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                // empty catch block
            }
        }
    }

    private static class RenameModuleAndDirectoryProcessor
    extends RenamePsiDirectoryProcessor {
        private final Module myModule;

        private RenameModuleAndDirectoryProcessor(@NotNull Module module) {
            this.myModule = module;
        }

        @Override
        @NotNull
        public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
            return new RenameWithOptionalReferencesDialog(project, element, nameSuggestionContext, editor){

                protected boolean getSearchForReferences() {
                    return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
                }

                protected void setSearchForReferences(boolean value2) {
                    RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value2;
                }

                protected void canRun() throws ConfigurationException {
                    super.canRun();
                    RenameModuleAndDirectoryHandler.checkRenameModule(myModule, this.getNewName());
                }

                protected RenameProcessor createRenameProcessor(final @NotNull String newName) {
                    return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                        public void performRefactoring(UsageInfo @NotNull [] usages) {
                            RenameModuleAndDirectoryHandler.renameModule(myModule, newName);
                            super.performRefactoring(usages);
                        }

                        @NotNull
                        protected String getCommandName() {
                            return JavaRefactoringBundle.message((String)"rename.module.directory.command", (Object[])new Object[]{newName});
                        }
                    };
                }
            };
        }
    }
}

