/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.migration;

import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMigration;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.migration.PsiMigrationManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.migration.MigrationMap;
import com.intellij.refactoring.migration.MigrationMapEntry;
import com.intellij.refactoring.migration.MigrationUsagesViewDescriptor;
import com.intellij.refactoring.migration.MigrationUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class MigrationProcessor
extends BaseRefactoringProcessor {
    private final MigrationMap myMigrationMap;
    private PsiMigration myPsiMigration;
    private final GlobalSearchScope mySearchScope;
    private ArrayList<SmartPsiElementPointer<PsiElement>> myRefsToShorten;

    public MigrationProcessor(Project project, MigrationMap migrationMap) {
        this(project, migrationMap, GlobalSearchScope.projectScope((Project)project));
    }

    public MigrationProcessor(Project project, MigrationMap migrationMap, GlobalSearchScope scope) {
        super(project);
        this.myMigrationMap = migrationMap;
        this.mySearchScope = scope;
        this.myPsiMigration = this.startMigration(project);
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new MigrationUsagesViewDescriptor(this.myMigrationMap, false);
    }

    private PsiMigration startMigration(Project project) {
        PsiMigration migration = PsiMigrationManager.getInstance(project).startMigration();
        this.findOrCreateEntries(project, migration);
        return migration;
    }

    private void findOrCreateEntries(Project project, PsiMigration migration) {
        for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
            MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
            if (entry.getType() == 0) {
                MigrationUtil.findOrCreatePackage(project, migration, entry.getOldName());
                continue;
            }
            MigrationUtil.findOrCreateClass(project, migration, entry.getOldName());
        }
    }

    protected void refreshElements(PsiElement @NotNull [] elements) {
        this.myPsiMigration = this.startMigration(this.myProject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UsageInfo @NotNull [] findUsages() {
        ArrayList<MigrationUsageInfo> usagesVector = new ArrayList<MigrationUsageInfo>();
        try {
            if (this.myMigrationMap == null) {
                UsageInfo[] usageInfoArray = UsageInfo.EMPTY_ARRAY;
                return usageInfoArray;
            }
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                UsageInfo[] usages = entry.getType() == 0 ? MigrationUtil.findPackageUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope) : MigrationUtil.findClassUsages(this.myProject, this.myPsiMigration, entry.getOldName(), this.mySearchScope);
                for (UsageInfo usage : usages) {
                    usagesVector.add(new MigrationUsageInfo(usage, entry));
                }
            }
        }
        finally {
            ApplicationManager.getApplication().invokeLater(() -> WriteAction.run(this::finishFindMigration), this.myProject.getDisposed());
        }
        return usagesVector.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private void finishFindMigration() {
        if (this.myPsiMigration != null) {
            this.myPsiMigration.finish();
            this.myPsiMigration = null;
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        if (((UsageInfo[])refUsages.get()).length == 0) {
            Messages.showInfoMessage((Project)this.myProject, (String)JavaRefactoringBundle.message((String)"migration.no.usages.found.in.the.project", (Object[])new Object[0]), (String)MigrationProcessor.getRefactoringName());
            return false;
        }
        this.setPreviewUsages(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        this.finishFindMigration();
        PsiMigration psiMigration = PsiMigrationManager.getInstance(this.myProject).startMigration();
        LocalHistoryAction a = LocalHistory.getInstance().startAction(this.getCommandName());
        this.myRefsToShorten = new ArrayList();
        try {
            boolean sameShortNames = false;
            for (int i = 0; i < this.myMigrationMap.getEntryCount(); ++i) {
                MigrationMapEntry entry = this.myMigrationMap.getEntryAt(i);
                String newName = entry.getNewName();
                PsiPackage element = entry.getType() == 0 ? MigrationUtil.findOrCreatePackage(this.myProject, psiMigration, newName) : MigrationUtil.findOrCreateClass(this.myProject, psiMigration, newName);
                MigrationUtil.doMigration((PsiElement)element, newName, usages, this.myRefsToShorten);
                if (sameShortNames || !Comparing.strEqual((String)StringUtil.getShortName((String)entry.getOldName()), (String)StringUtil.getShortName((String)entry.getNewName()))) continue;
                sameShortNames = true;
            }
            if (!sameShortNames) {
                this.myRefsToShorten.clear();
            }
        }
        finally {
            a.finish();
            psiMigration.finish();
        }
    }

    protected void performPsiSpoilingRefactoring() {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        for (SmartPsiElementPointer<PsiElement> pointer : this.myRefsToShorten) {
            PsiElement element = pointer.getElement();
            if (element == null) continue;
            styleManager.shortenClassReferences(element);
        }
    }

    @NotNull
    protected String getCommandName() {
        return MigrationProcessor.getRefactoringName();
    }

    private static String getRefactoringName() {
        return JavaRefactoringBundle.message((String)"migration.title", (Object[])new Object[0]);
    }

    static class MigrationUsageInfo
    extends UsageInfo {
        MigrationMapEntry mapEntry;

        MigrationUsageInfo(UsageInfo info, MigrationMapEntry mapEntry) {
            super(info.getElement(), info.getRangeInElement().getStartOffset(), info.getRangeInElement().getEndOffset());
            this.mapEntry = mapEntry;
        }
    }
}

