/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inlineSuperClass.usageInfo;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.util.IncorrectOperationException;

public class ReplaceReferenceUsageInfo
extends FixableUsageInfo {
    private final PsiClass myTargetClass;
    private final String myConflict;

    public ReplaceReferenceUsageInfo(PsiElement referenceExpression, PsiClass[] targetClasses) {
        super(referenceExpression);
        this.myTargetClass = targetClasses[0];
        this.myConflict = targetClasses.length > 1 ? referenceExpression.getText() + "can be replaced with any of " + StringUtil.join((Object[])targetClasses, psiClass -> psiClass.getQualifiedName(), (String)", ") : null;
    }

    public void fixUsage() throws IncorrectOperationException {
        PsiElement referenceExpression = this.getElement();
        if (referenceExpression != null) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.getProject());
            referenceExpression.replace((PsiElement)(referenceExpression instanceof PsiReferenceExpression ? elementFactory.createReferenceExpression(this.myTargetClass) : elementFactory.createClassReferenceElement(this.myTargetClass)));
        }
    }

    public String getConflictMessage() {
        return this.myConflict;
    }
}

