/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.inline.InlineOptionsWithSearchSettingsDialog;
import com.intellij.refactoring.inline.InlineToAnonymousClassProcessor;

public class InlineToAnonymousClassDialog
extends InlineOptionsWithSearchSettingsDialog {
    private final PsiClass myClass;
    private final PsiCall myCallToInline;

    protected InlineToAnonymousClassDialog(Project project, PsiClass psiClass, PsiCall callToInline, boolean isInvokeOnReference) {
        super(project, true, (PsiElement)psiClass);
        this.myClass = psiClass;
        this.myCallToInline = callToInline;
        this.myInvokedOnReference = isInvokeOnReference;
        this.setTitle(JavaRefactoringBundle.message((String)"inline.to.anonymous.refactoring", (Object[])new Object[0]));
        this.init();
    }

    protected String getNameLabelText() {
        String className2 = PsiFormatUtil.formatClass((PsiClass)this.myClass, (int)1);
        return JavaRefactoringBundle.message((String)"inline.to.anonymous.name.label", (Object[])new Object[]{className2});
    }

    protected String getBorderTitle() {
        return JavaRefactoringBundle.message((String)"inline.to.anonymous.border.title", (Object[])new Object[0]);
    }

    protected String getInlineAllText() {
        return JavaRefactoringBundle.message((String)"all.references.and.remove.the.class", (Object[])new Object[0]);
    }

    protected String getInlineThisText() {
        return JavaRefactoringBundle.message((String)"this.reference.only.and.keep.the.class", (Object[])new Object[0]);
    }

    protected boolean isInlineThis() {
        return false;
    }

    protected boolean isSearchInCommentsAndStrings() {
        return JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_COMMENTS;
    }

    protected boolean isSearchForTextOccurrences() {
        return JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_NON_JAVA;
    }

    protected void doAction() {
        super.doAction();
        this.invokeRefactoring(new InlineToAnonymousClassProcessor(this.getProject(), this.myClass, this.myCallToInline, this.isInlineThisOnly(), this.isSearchInCommentsAndStrings(), this.isSearchForTextOccurrences()));
    }

    protected void saveSearchInCommentsAndStrings(boolean searchInComments) {
        JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_COMMENTS = searchInComments;
    }

    protected boolean allowInlineAll() {
        return true;
    }

    protected void saveSearchInTextOccurrences(boolean searchInTextOccurrences) {
        JavaRefactoringSettings.getInstance().INLINE_CLASS_SEARCH_IN_NON_JAVA = searchInTextOccurrences;
    }

    protected String getHelpId() {
        return "refactoring.inlineClass";
    }
}

