/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.editorActions.DeclarationJoinLinesHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.inline.InlineMethodHelper;
import com.intellij.refactoring.inline.InlineMethodProcessor;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.inline.InlineViewDescriptor;
import com.intellij.refactoring.inline.ReferencedElementsCollector;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.TypeUtils;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InlineObjectProcessor
extends BaseRefactoringProcessor {
    private final PsiMethod myMethod;
    private final PsiReference myReference;
    private final PsiNewExpression myNewExpression;
    private final PsiMethodCallExpression myNextCall;
    private final PsiMethod myNextMethod;

    private InlineObjectProcessor(PsiMethod method, PsiReference reference) {
        super(method.getProject());
        this.myMethod = method;
        this.myReference = reference;
        PsiElement element = this.myReference.getElement();
        this.myNewExpression = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class);
        assert (this.myNewExpression != null);
        this.myNextCall = ExpressionUtils.getCallForQualifier((PsiExpression)this.myNewExpression);
        assert (this.myNextCall != null);
        PsiMethod nextMethod = this.myNextCall.resolveMethod();
        assert (nextMethod != null);
        PsiElement nav = nextMethod.getNavigationElement();
        if (nav instanceof PsiMethod) {
            nextMethod = (PsiMethod)nav;
        }
        this.myNextMethod = nextMethod;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        return new InlineViewDescriptor((PsiElement)this.myMethod);
    }

    @NotNull
    protected Collection<? extends PsiElement> getElementsToWrite(@NotNull UsageViewDescriptor descriptor) {
        return Collections.singletonList(this.myReference.getElement());
    }

    protected UsageInfo @NotNull [] findUsages() {
        return new UsageInfo[]{new UsageInfo(this.myReference)};
    }

    protected void performRefactoring(UsageInfo @NotNull [] usages) {
        PsiLocalVariable resultVar;
        PsiReferenceExpression resultUsage;
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myMethod, false);
        PsiMethod ctorCopy = (PsiMethod)this.myMethod.copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myMethod);
        ChangeContextUtil.encodeContextInfo((PsiElement)this.myNextMethod, false);
        PsiMethod nextCopy = (PsiMethod)this.myNextMethod.copy();
        ChangeContextUtil.clearContextInfo((PsiElement)this.myNextMethod);
        InlineMethodHelper ctorHelper = new InlineMethodHelper(this.myProject, this.myMethod, ctorCopy, (PsiCallExpression)this.myNewExpression);
        InlineMethodHelper nextHelper = new InlineMethodHelper(this.myProject, this.myNextMethod, nextCopy, (PsiCallExpression)this.myNextCall);
        PsiClass aClass = this.myMethod.getContainingClass();
        assert (aClass != null);
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        PsiCodeBlock target = factory.createCodeBlock();
        ArrayList<PsiLocalVariable> fieldLocals = new ArrayList<PsiLocalVariable>();
        for (PsiField field : aClass.getFields()) {
            if (field.hasModifierProperty("static")) continue;
            PsiDeclarationStatement declaration2 = factory.createVariableDeclarationStatement(field.getName(), field.getType(), field.getInitializer(), (PsiElement)aClass);
            fieldLocals.add((PsiLocalVariable)((PsiDeclarationStatement)target.add((PsiElement)declaration2)).getDeclaredElements()[0]);
        }
        PsiLocalVariable[] ctorParameters = ctorHelper.declareParameters();
        InlineTransformer ctorTransformer = InlineTransformer.getSuitableTransformer(this.myMethod).apply(this.myReference);
        ctorTransformer.transformBody(ctorCopy, this.myReference, (PsiType)PsiType.VOID);
        PsiCodeBlock ctorBody = Objects.requireNonNull(ctorCopy.getBody());
        InlineUtil.solveVariableNameConflicts((PsiElement)ctorBody, (PsiElement)target, (PsiElement)ctorBody);
        InlineObjectProcessor.updateFieldRefs(ctorCopy, aClass);
        ctorParameters = InlineObjectProcessor.addRange(target, ctorBody, ctorParameters);
        Object[] nextParameters = nextHelper.declareParameters();
        InlineTransformer nextTransformer = InlineTransformer.getSuitableTransformer(this.myNextMethod).apply((PsiReference)this.myNextCall.getMethodExpression());
        PsiLocalVariable result = nextTransformer.transformBody(nextCopy, (PsiReference)this.myNextCall.getMethodExpression(), this.myNextCall.getType());
        PsiCodeBlock nextBody = Objects.requireNonNull(nextCopy.getBody());
        InlineUtil.solveVariableNameConflicts((PsiElement)nextBody, (PsiElement)target, (PsiElement)nextBody);
        InlineObjectProcessor.updateFieldRefs(nextCopy, aClass);
        if (result != null) {
            PsiLocalVariable[] resultAndParameters = (PsiLocalVariable[])ArrayUtil.prepend((Object)result, (Object[])nextParameters);
            resultAndParameters = InlineObjectProcessor.addRange(target, nextBody, resultAndParameters);
            result = resultAndParameters[0];
            nextParameters = Arrays.copyOfRange(resultAndParameters, 1, resultAndParameters.length);
        } else {
            nextParameters = InlineObjectProcessor.addRange(target, nextBody, (PsiLocalVariable[])nextParameters);
        }
        InlineUtil.solveVariableNameConflicts((PsiElement)target, this.myReference.getElement(), (PsiElement)target);
        ctorHelper.initializeParameters(ctorParameters);
        nextHelper.initializeParameters((PsiLocalVariable[])nextParameters);
        InlineObjectProcessor.removeRedundantFieldVars(fieldLocals, target);
        ctorHelper.inlineParameters(ctorParameters);
        nextHelper.inlineParameters((PsiLocalVariable[])nextParameters);
        PsiElement anchor = RefactoringUtil.getParentStatement((PsiElement)this.myNextCall, true);
        assert (anchor != null);
        PsiElement anchorParent = anchor.getParent();
        PsiStatement[] statements = target.getStatements();
        PsiElement firstBodyElement = target.getFirstBodyElement();
        if (firstBodyElement instanceof PsiWhiteSpace) {
            firstBodyElement = PsiTreeUtil.skipWhitespacesForward((PsiElement)firstBodyElement);
        }
        PsiElement firstAdded = null;
        if (firstBodyElement != null && firstBodyElement != target.getRBrace()) {
            PsiElement rBraceOrReturnStatement;
            int last = statements.length - 1;
            PsiElement psiElement = rBraceOrReturnStatement = last >= 0 ? PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)statements[last]) : target.getLastBodyElement();
            assert (rBraceOrReturnStatement != null);
            PsiElement beforeRBraceStatement = rBraceOrReturnStatement.getPrevSibling();
            assert (beforeRBraceStatement != null);
            firstAdded = anchorParent.addRangeBefore(firstBodyElement, beforeRBraceStatement, anchor);
            ChangeContextUtil.decodeContextInfo(anchorParent, null, null);
        }
        if ((resultUsage = InlineMethodProcessor.replaceCall(factory, this.myNextCall, firstAdded, result)) != null && (resultVar = ExpressionUtils.resolveLocalVariable((PsiExpression)resultUsage)) != null) {
            InlineUtil.tryInlineResultVariable(resultVar, resultUsage);
        }
    }

    private static void removeRedundantFieldVars(List<PsiLocalVariable> vars, PsiCodeBlock block) {
        for (PsiLocalVariable var : vars) {
            List<PsiReferenceExpression> references = VariableAccessUtils.getVariableReferences((PsiVariable)var, (PsiElement)block);
            PsiAssignmentExpression firstAssignment = null;
            ArrayList<PsiAssignmentExpression> assignments = new ArrayList<PsiAssignmentExpression>();
            for (PsiReferenceExpression reference : references) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)ObjectUtils.tryCast((Object)PsiUtil.skipParenthesizedExprUp((PsiElement)reference.getParent()), PsiAssignmentExpression.class);
                if (assignment != null && assignment.getOperationTokenType().equals(JavaTokenType.EQ) && PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getLExpression()) == reference && assignment.getParent() instanceof PsiExpressionStatement) {
                    assignments.add(assignment);
                    if (firstAssignment != null || assignment.getParent().getParent() != block) continue;
                    firstAssignment = assignment;
                    continue;
                }
                assignments = null;
                break;
            }
            if (assignments != null) {
                for (PsiAssignmentExpression assignment : assignments) {
                    PsiExpressionStatement statement = (PsiExpressionStatement)assignment.getParent();
                    PsiExpression expression2 = assignment.getRExpression();
                    CommentTracker ct = new CommentTracker();
                    if (expression2 != null) {
                        List<PsiExpression> sideEffects = SideEffectChecker.extractSideEffectExpressions(expression2);
                        sideEffects.forEach(ct::markUnchanged);
                        PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, expression2);
                        if (statements.length > 0) {
                            BlockUtils.addBefore((PsiStatement)statement, statements);
                        }
                    }
                    ct.deleteAndRestoreComments((PsiElement)statement);
                }
                new CommentTracker().deleteAndRestoreComments((PsiElement)var);
                continue;
            }
            if (firstAssignment == null) continue;
            var = DeclarationJoinLinesHandler.joinDeclarationAndAssignment(var, firstAssignment);
            InlineUtil.tryInlineGeneratedLocal(var, false);
        }
    }

    private static PsiLocalVariable[] addRange(PsiCodeBlock target, PsiCodeBlock body2, PsiLocalVariable[] declaredVars) {
        PsiElement firstBodyElement = body2.getFirstBodyElement();
        PsiElement lastBodyElement = body2.getLastBodyElement();
        if (firstBodyElement == null || lastBodyElement == null) {
            return declaredVars;
        }
        PsiElement firstAdded = target.addRange(firstBodyElement, lastBodyElement);
        PsiLocalVariable[] updatedVars = new PsiLocalVariable[declaredVars.length];
        int index = 0;
        for (PsiElement e = firstAdded; index < updatedVars.length && e != null; e = e.getNextSibling()) {
            PsiLocalVariable var;
            PsiElement[] elements;
            if (!(e instanceof PsiDeclarationStatement) || (elements = ((PsiDeclarationStatement)e).getDeclaredElements()).length != 1 || (var = (PsiLocalVariable)ObjectUtils.tryCast((Object)elements[0], PsiLocalVariable.class)) == null || !var.getName().equals(declaredVars[index].getName())) continue;
            updatedVars[index++] = var;
        }
        assert (index == updatedVars.length);
        return updatedVars;
    }

    private static void updateFieldRefs(PsiMethod method, PsiClass aClass) {
        PsiCodeBlock body2 = method.getBody();
        assert (body2 != null);
        for (PsiThisExpression thisExpression : PsiTreeUtil.findChildrenOfType((PsiElement)body2, PsiThisExpression.class)) {
            PsiField field;
            PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)thisExpression.getParent());
            if (!(parent instanceof PsiReferenceExpression) || (field = (PsiField)ObjectUtils.tryCast((Object)((PsiReferenceExpression)parent).resolve(), PsiField.class)) == null || field.getContainingClass() != aClass) continue;
            thisExpression.delete();
        }
    }

    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        UsageInfo[] usagesIn = (UsageInfo[])refUsages.get();
        MultiMap conflicts = new MultiMap();
        ReferencedElementsCollector collector = new ReferencedElementsCollector();
        this.myMethod.accept((PsiElementVisitor)collector);
        this.myNextMethod.accept((PsiElementVisitor)collector);
        Map<PsiMember, Set<PsiMember>> containersToReferenced = InlineMethodProcessor.getInaccessible(collector.myReferencedMembers, usagesIn, (PsiElement)this.myMethod);
        containersToReferenced.forEach((container, referencedInaccessible) -> {
            for (PsiMember referenced : referencedInaccessible) {
                if (referenced instanceof PsiField && !referenced.hasModifierProperty("static") && referenced.getContainingClass() == this.myMethod.getContainingClass()) continue;
                String referencedDescription = RefactoringUIUtil.getDescription((PsiElement)referenced, (boolean)true);
                String containerDescription = RefactoringUIUtil.getDescription((PsiElement)container, (boolean)true);
                String message2 = RefactoringBundle.message((String)"0.that.is.used.in.inlined.method.is.not.accessible.from.call.site.s.in.1", (Object[])new Object[]{referencedDescription, containerDescription});
                conflicts.putValue(container, (Object)CommonRefactoringUtil.capitalize((String)message2));
            }
        });
        return this.showConflicts(conflicts, usagesIn);
    }

    @NotNull
    protected String getCommandName() {
        return "Inline Object";
    }

    @Nullable
    public static InlineObjectProcessor create(PsiReference reference, PsiMethod method) {
        if (!InlineObjectProcessor.canInlineConstructorAndChainCall(reference, method)) {
            return null;
        }
        return new InlineObjectProcessor(method, reference);
    }

    @Contract(value="null, _ -> false")
    private static boolean canInlineConstructorAndChainCall(PsiReference reference, PsiMethod method) {
        PsiClass aClass;
        if (reference == null) {
            return false;
        }
        PsiElement element = reference.getElement();
        if (!(element instanceof PsiJavaCodeReferenceElement)) {
            return false;
        }
        PsiNewExpression expression2 = (PsiNewExpression)ObjectUtils.tryCast((Object)element.getParent(), PsiNewExpression.class);
        if (expression2 == null) {
            return false;
        }
        PsiMethodCallExpression call = ExpressionUtils.getCallForQualifier((PsiExpression)expression2);
        if (call == null) {
            return false;
        }
        if (RefactoringUtil.getParentStatement((PsiElement)call, true) == null) {
            return false;
        }
        PsiMethod nextMethod = call.resolveMethod();
        if (nextMethod == null) {
            return false;
        }
        PsiElement nav = nextMethod.getNavigationElement();
        if (nav instanceof PsiMethod) {
            nextMethod = (PsiMethod)nav;
        }
        if ((aClass = method.getContainingClass()) == null) {
            return false;
        }
        if (aClass.getContainingClass() != null && !aClass.hasModifierProperty("static")) {
            return false;
        }
        PsiClassType[] supers = aClass.getExtendsListTypes();
        if (supers.length > 1) {
            return false;
        }
        if (supers.length == 1 && !InlineObjectProcessor.isStatelessSuperClass(supers[0], new HashSet<PsiClass>())) {
            return false;
        }
        for (PsiField psiField : aClass.getFields()) {
            PsiExpression initializer;
            if (psiField.hasModifierProperty("static") || (initializer = psiField.getInitializer()) == null || !InlineObjectProcessor.mayLeakThis((PsiElement)initializer)) continue;
            return false;
        }
        for (PsiField psiField : aClass.getInitializers()) {
            if (psiField.hasModifierProperty("static")) continue;
            return false;
        }
        return !InlineObjectProcessor.mayLeakThis(method) && !InlineObjectProcessor.mayLeakThis(nextMethod);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isStatelessSuperClass(PsiClassType psiType, Set<PsiClass> checked) {
        PsiMethod[] constructors;
        if (TypeUtils.isJavaLangObject((PsiType)psiType)) {
            return true;
        }
        PsiClass psiClass = psiType.resolve();
        if (psiClass == null || !checked.add(psiClass)) {
            return false;
        }
        for (PsiMethod psiMethod : constructors = psiClass.getConstructors()) {
            void var7_7;
            PsiCodeBlock body2;
            if (!psiMethod.getParameterList().isEmpty()) continue;
            PsiElement nav = psiMethod.getNavigationElement();
            if (nav instanceof PsiMethod) {
                PsiMethod psiMethod2 = (PsiMethod)nav;
            }
            if ((body2 = var7_7.getBody()) != null && ControlFlowUtils.isEmptyCodeBlock(body2)) continue;
            return false;
        }
        for (PsiMethod psiMethod : psiClass.getFields()) {
            if (psiMethod.hasModifierProperty("static")) continue;
            return false;
        }
        PsiClassType[] supers = psiClass.getExtendsListTypes();
        return supers.length == 0 || supers.length == 1 && InlineObjectProcessor.isStatelessSuperClass(supers[0], checked);
    }

    private static boolean mayLeakThis(PsiMethod method) {
        if (method == null) {
            return true;
        }
        PsiCodeBlock body2 = method.getBody();
        if (body2 == null) {
            return true;
        }
        return InlineObjectProcessor.mayLeakThis((PsiElement)body2);
    }

    private static boolean mayLeakThis(PsiElement body2) {
        class Visitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean leak = false;

            Visitor() {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression call) {
                super.visitMethodCallExpression(call);
                PsiExpression qualifier = ExpressionUtils.getEffectiveQualifier(call.getMethodExpression());
                if (qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression) {
                    this.leak = true;
                    this.stopWalking();
                }
            }

            public void visitNewExpression(PsiNewExpression expression2) {
                PsiClass target;
                PsiJavaCodeReferenceElement reference;
                super.visitNewExpression(expression2);
                if (expression2.getQualifier() == null && (reference = expression2.getClassReference()) != null && (target = (PsiClass)ObjectUtils.tryCast((Object)reference.resolve(), PsiClass.class)) != null && target.getContainingClass() != null && !target.hasModifierProperty("static")) {
                    this.leak = true;
                    this.stopWalking();
                }
            }

            public void visitThisExpression(PsiThisExpression expression2) {
                super.visitThisExpression(expression2);
                PsiElement parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent());
                if (!(parent instanceof PsiReferenceExpression)) {
                    this.leak = true;
                    this.stopWalking();
                }
            }
        }
        Visitor visitor2 = new Visitor();
        body2.accept((PsiElementVisitor)visitor2);
        return visitor2.leak;
    }
}

