/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.inline;

import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.util.ObjectUtils;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.ArrayList;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class BooleanReturnModel {
    private final boolean myEarlyReturnValue;
    private final int myEarlyReturnValueCount;
    private final int myTerminalNonRemovableValueCount;
    private final boolean myHasReturnInLoopOrSwitch;

    BooleanReturnModel(boolean value2, int count, int terminalNonRemovableValueCount, boolean hasReturnInLoopOrSwitch) {
        this.myEarlyReturnValue = value2;
        this.myEarlyReturnValueCount = count;
        this.myTerminalNonRemovableValueCount = terminalNonRemovableValueCount;
        this.myHasReturnInLoopOrSwitch = hasReturnInLoopOrSwitch;
    }

    @Nullable
    InlineTransformer getTransformer(PsiReference ref) {
        PsiElement parent;
        if (!(ref instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiMethodCallExpression call = (PsiMethodCallExpression)ObjectUtils.tryCast((Object)((PsiReferenceExpression)ref).getParent(), PsiMethodCallExpression.class);
        if (call == null) {
            return null;
        }
        boolean wantedValue = true;
        PsiMethodCallExpression expression2 = call;
        while ((parent = PsiUtil.skipParenthesizedExprUp((PsiElement)expression2.getParent())) instanceof PsiPrefixExpression && JavaTokenType.EXCL.equals(((PsiPrefixExpression)parent).getOperationTokenType())) {
            wantedValue = !wantedValue;
            expression2 = (PsiPrefixExpression)parent;
        }
        if (parent instanceof PsiIfStatement) {
            boolean allowReplacement;
            PsiIfStatement ifStatement = (PsiIfStatement)parent;
            PsiStatement thenStatement = ControlFlowUtils.stripBraces(ifStatement.getThenBranch());
            PsiStatement elseStatement = ControlFlowUtils.stripBraces(ifStatement.getElseBranch());
            if (elseStatement == null && wantedValue == this.myEarlyReturnValue && (allowReplacement = this.myEarlyReturnValueCount == 1 && this.myTerminalNonRemovableValueCount == 0 ? this.isJumpOut(thenStatement) : this.isCopyableJumpOut(thenStatement))) {
                return this.getTransformer(thenStatement, null);
            }
            if (this.isJumpOut(thenStatement) && this.isJumpOut(elseStatement) && this.myTerminalNonRemovableValueCount == 0 && this.myEarlyReturnValueCount == 1) {
                PsiStatement earlyStatement = this.myEarlyReturnValue == wantedValue ? thenStatement : elseStatement;
                PsiStatement finalStatement = this.myEarlyReturnValue != wantedValue ? thenStatement : elseStatement;
                return this.getTransformer(earlyStatement, finalStatement);
            }
        }
        return null;
    }

    private boolean isJumpOut(PsiStatement statement) {
        return statement instanceof PsiReturnStatement || statement instanceof PsiThrowStatement || !this.myHasReturnInLoopOrSwitch && (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement);
    }

    private boolean isCopyableJumpOut(PsiStatement statement) {
        if (!this.myHasReturnInLoopOrSwitch && (statement instanceof PsiBreakStatement || statement instanceof PsiContinueStatement)) {
            return true;
        }
        if (statement instanceof PsiReturnStatement) {
            PsiReturnStatement thenReturn = (PsiReturnStatement)statement;
            return thenReturn.getReturnValue() == null || ExpressionUtils.isSafelyRecomputableExpression(thenReturn.getReturnValue());
        }
        return false;
    }

    @NotNull
    private InlineTransformer getTransformer(PsiStatement earlyStatement, PsiStatement finalStatement) {
        return (methodCopy, callSite, returnType) -> {
            PsiReturnStatement[] returns;
            PsiCodeBlock block = Objects.requireNonNull(methodCopy.getBody());
            for (PsiReturnStatement returnStatement : returns = PsiUtil.findReturnStatements((PsiMethod)methodCopy)) {
                Boolean value2;
                PsiExpression returnValue = Objects.requireNonNull(returnStatement.getReturnValue());
                PsiLiteralExpression literal = ExpressionUtils.getLiteral(returnValue);
                Boolean bl = value2 = literal == null ? null : (Boolean)ObjectUtils.tryCast((Object)literal.getValue(), Boolean.class);
                if (value2 == null) {
                    CommentTracker tracker = new CommentTracker();
                    String condition2 = this.myEarlyReturnValue ? tracker.text((PsiElement)returnValue) : BoolUtils.getNegatedExpressionText(returnValue, tracker);
                    tracker.replaceAndRestoreComments((PsiElement)returnStatement, "if(" + condition2 + ") {" + earlyStatement.getText() + "}");
                    continue;
                }
                if (value2 == this.myEarlyReturnValue) {
                    new CommentTracker().replaceAndRestoreComments((PsiElement)returnStatement, (PsiElement)earlyStatement);
                    continue;
                }
                new CommentTracker().delete((PsiElement)returnStatement);
            }
            if (finalStatement != null) {
                block.addBefore((PsiElement)finalStatement, (PsiElement)block.getRBrace());
            }
            return null;
        };
    }

    @Nullable
    static BooleanReturnModel from(@NotNull PsiCodeBlock body2, PsiReturnStatement @NotNull [] returns) {
        ArrayList<PsiExpression> terminal = new ArrayList<PsiExpression>();
        boolean earlyValue = false;
        int earlyCount = 0;
        boolean hasReturnInLoopOrSwitch = false;
        for (PsiReturnStatement returnStatement : returns) {
            PsiExpression returnValue;
            if (!hasReturnInLoopOrSwitch) {
                hasReturnInLoopOrSwitch = BooleanReturnModel.isInLoopOrSwitch(body2, returnStatement);
            }
            if ((returnValue = returnStatement.getReturnValue()) == null || !PsiType.BOOLEAN.equals((Object)returnValue.getType())) {
                return null;
            }
            if (ControlFlowUtils.blockCompletesWithStatement(body2, (PsiStatement)returnStatement)) {
                terminal.add(returnValue);
                continue;
            }
            PsiLiteralExpression literal = ExpressionUtils.getLiteral(returnValue);
            if (literal == null) {
                return null;
            }
            Boolean literalValue = (Boolean)ObjectUtils.tryCast((Object)literal.getValue(), Boolean.class);
            if (literalValue == null) {
                return null;
            }
            if (earlyCount == 0) {
                earlyValue = literalValue;
            } else if (earlyValue != literalValue) {
                return null;
            }
            ++earlyCount;
        }
        if (earlyCount == 0) {
            return null;
        }
        int terminalCount = 0;
        for (PsiExpression value2 : terminal) {
            PsiLiteralExpression literal = ExpressionUtils.getLiteral(value2);
            if (literal == null || !(literal.getValue() instanceof Boolean)) {
                ++terminalCount;
                continue;
            }
            if (!literal.getValue().equals(earlyValue)) continue;
            ++earlyCount;
        }
        return new BooleanReturnModel(earlyValue, earlyCount, terminalCount, hasReturnInLoopOrSwitch);
    }

    private static boolean isInLoopOrSwitch(@NotNull PsiCodeBlock body2, @NotNull PsiReturnStatement returnStatement) {
        for (PsiElement parent = returnStatement.getParent(); parent != body2; parent = parent.getParent()) {
            if (!(parent instanceof PsiLoopStatement) && !(parent instanceof PsiSwitchStatement)) continue;
            return true;
        }
        return false;
    }
}

