/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.MemberQualifierUtil;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import java.util.Objects;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(MethodDescriptor.class);
    private final PsiMethodCallExpression myCallExpression;
    private final PsiMethod myMethod;
    private final String myAccessibleReturnType;

    public MethodDescriptor(@NotNull PsiMethodCallExpression expression2, @NotNull PsiMethod method) {
        this.myCallExpression = expression2;
        this.myMethod = method;
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myCallExpression, MethodDescriptor.resolveMethodReturnType(expression2, method));
        if (returnType == null) {
            LOG.warn("Could not resolve method return type. java.lang.Object will be used instead");
            returnType = "java.lang.Object";
        }
        this.myAccessibleReturnType = returnType;
    }

    public static MethodDescriptor createIfInaccessible(@NotNull PsiClass outerClass, @NotNull PsiMethodCallExpression expression2) {
        PsiMethod method = expression2.resolveMethod();
        if (method != null && !Objects.equals(method.getContainingClass(), outerClass)) {
            return MethodDescriptor.needReplace(outerClass, method, expression2) ? new MethodDescriptor(expression2, method) : null;
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        PsiClass containingClass = this.myMethod.getContainingClass();
        String containingClassName = containingClass == null ? null : ClassUtil.getJVMClassName((PsiClass)containingClass);
        String name2 = this.myMethod.getName();
        if (containingClassName == null) {
            LOG.warn("containing class for method \"" + name2 + "\" not found");
            return;
        }
        String newMethodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, "call" + StringUtil.capitalize((String)name2));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(newMethodName);
        PsiMethod newMethod = methodBuilder.accessedMethod(containingClassName, this.myMethod.getName()).setStatic(outerClass.hasModifierProperty("static")).addParameter("java.lang.Object", "object").addParameters(this.myMethod.getParameterList()).setReturnType(this.myAccessibleReturnType).build(elementFactory, (PsiElement)outerClass);
        outerClass.add((PsiElement)newMethod);
        String objectToCallOn = MemberQualifierUtil.findObjectExpression(this.myCallExpression.getMethodExpression(), (PsiMember)this.myMethod, outerClass, callExpression, elementFactory);
        String args = StreamEx.of((Object[])this.myCallExpression.getArgumentList().getExpressions()).map(x -> x.getText()).prepend((Object)(objectToCallOn == null ? "null" : objectToCallOn)).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String newMethodCallExpression = newMethod.getName() + args;
        this.myCallExpression.replace((PsiElement)elementFactory.createExpressionFromText(newMethodCallExpression, (PsiElement)this.myCallExpression));
    }

    private static boolean needReplace(@NotNull PsiClass outerClass, @NotNull PsiMethod method, @NotNull PsiMethodCallExpression referenceExpression) {
        PsiExpression qualifier = referenceExpression.getMethodExpression().getQualifierExpression();
        return !PsiReflectionAccessUtil.isAccessibleMember((PsiMember)method, outerClass, qualifier);
    }

    @Nullable
    private static PsiType resolveMethodReturnType(@NotNull PsiMethodCallExpression callExpression, @NotNull PsiMethod method) {
        PsiSubstitutor substitutor = callExpression.resolveMethodGenerics().getSubstitutor();
        return substitutor.substitute(method.getReturnType());
    }
}

