/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldDeclarationDescriptor
implements ItemToReplaceDescriptor {
    private final PsiField myField;
    private final String myName;

    private FieldDeclarationDescriptor(@NotNull PsiField field, @NotNull String name2) {
        this.myField = field;
        this.myName = name2;
    }

    @Nullable
    public static ItemToReplaceDescriptor createIfInaccessible(@NotNull PsiField field) {
        String fieldName = field.getName();
        if (!PsiReflectionAccessUtil.isAccessibleType(field.getType())) {
            return new FieldDeclarationDescriptor(field, fieldName);
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        PsiField newField = elementFactory.createField(this.myName, PsiReflectionAccessUtil.nearestAccessibleType(this.myField.getType()));
        this.myField.replace((PsiElement)newField);
    }
}

