/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject.reflect;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.util.ClassUtil;
import com.intellij.refactoring.extractMethodObject.ItemToReplaceDescriptor;
import com.intellij.refactoring.extractMethodObject.reflect.PsiReflectionAccessUtil;
import com.intellij.refactoring.extractMethodObject.reflect.ReflectionAccessMethodBuilder;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstructorDescriptor
implements ItemToReplaceDescriptor {
    private static final Logger LOG = Logger.getInstance(ConstructorDescriptor.class);
    private final PsiNewExpression myNewExpression;
    private final PsiClass myPsiClass;
    @Nullable
    private final PsiMethod myConstructor;

    private ConstructorDescriptor(@NotNull PsiNewExpression expression2, @Nullable PsiMethod constructor, @NotNull PsiClass psiClass) {
        this.myNewExpression = expression2;
        this.myConstructor = constructor;
        this.myPsiClass = psiClass;
    }

    @Nullable
    public static ConstructorDescriptor createIfInaccessible(@NotNull PsiNewExpression expression2) {
        PsiMethod constructor = expression2.resolveConstructor();
        if (constructor != null) {
            PsiClass containingClass = constructor.getContainingClass();
            if (containingClass != null && !PsiReflectionAccessUtil.isPublicMember((PsiMember)constructor)) {
                return new ConstructorDescriptor(expression2, constructor, containingClass);
            }
        } else {
            PsiElement referent;
            PsiJavaCodeReferenceElement classReference2 = expression2.getClassReference();
            PsiElement psiElement = referent = classReference2 != null ? classReference2.resolve() : null;
            if (referent instanceof PsiClass && !PsiReflectionAccessUtil.isAccessible((PsiClass)referent)) {
                return new ConstructorDescriptor(expression2, null, (PsiClass)referent);
            }
        }
        return null;
    }

    @Override
    public void replace(@NotNull PsiClass outerClass, @NotNull PsiElementFactory elementFactory, @NotNull PsiMethodCallExpression callExpression) {
        String className2 = ClassUtil.getJVMClassName((PsiClass)this.myPsiClass);
        String returnType = PsiReflectionAccessUtil.getAccessibleReturnType((PsiExpression)this.myNewExpression, this.myPsiClass);
        PsiExpressionList argumentList = this.myNewExpression.getArgumentList();
        if (className2 == null || argumentList == null || returnType == null) {
            LOG.warn("code is incomplete: " + this.myNewExpression);
            return;
        }
        String methodName = PsiReflectionAccessUtil.getUniqueMethodName(outerClass, ConstructorDescriptor.methodName(className2));
        ReflectionAccessMethodBuilder methodBuilder = new ReflectionAccessMethodBuilder(methodName);
        methodBuilder.accessedConstructor(className2).setStatic(outerClass.hasModifierProperty("static")).setReturnType(returnType);
        if (this.myConstructor != null) {
            methodBuilder.addParameters(this.myConstructor.getParameterList());
        }
        PsiMethod newPsiMethod = methodBuilder.build(elementFactory, (PsiElement)outerClass);
        outerClass.add((PsiElement)newPsiMethod);
        String args = StreamEx.of((Object[])argumentList.getExpressions()).map(x -> x.getText()).joining((CharSequence)", ", (CharSequence)"(", (CharSequence)")");
        String newCallExpression = newPsiMethod.getName() + args;
        this.myNewExpression.replace((PsiElement)elementFactory.createExpressionFromText(newCallExpression, (PsiElement)this.myNewExpression));
    }

    @NotNull
    private static String methodName(@NotNull String jvmClassName) {
        String name2 = StringUtil.getShortName((String)jvmClassName);
        return "new" + StringUtil.capitalize((String)name2);
    }
}

