/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassUtil {
    private static final Logger LOG = Logger.getInstance(CreateClassUtil.class);
    @NonNls
    public static final String DEFAULT_CLASS_TEMPLATE = "#DEFAULT_CLASS_TEMPLATE";
    @NonNls
    private static final String DO_NOT_CREATE_CLASS_TEMPLATE = "#DO_NOT_CREATE_CLASS_TEMPLATE";
    @NonNls
    private static final String CLASS_NAME_PROPERTY = "Class_Name";
    @NonNls
    private static final String INTERFACE_NAME_PROPERTY = "Interface_Name";

    private CreateClassUtil() {
    }

    @Nullable
    private static PsiClass createClassFromTemplate(@NotNull Properties attributes, @Nullable String templateName, @NotNull PsiDirectory directoryRoot, @NotNull String className2) throws IncorrectOperationException {
        if (templateName == null) {
            return null;
        }
        if (templateName.equals(DO_NOT_CREATE_CLASS_TEMPLATE)) {
            return null;
        }
        Project project = directoryRoot.getProject();
        try {
            PsiClass aClass;
            String rawClassName;
            PsiFile existing;
            PsiDirectory directory = CreateClassUtil.createParentDirectories(directoryRoot, className2);
            PsiFile psiFile = directory.findFile(className2 + "." + JavaFileType.INSTANCE.getDefaultExtension());
            if (psiFile != null) {
                psiFile.delete();
            }
            if ((existing = directory.findFile((rawClassName = CreateClassUtil.extractClassName(className2)) + ".java")) instanceof PsiJavaFile) {
                PsiClass[] classes2 = ((PsiJavaFile)existing).getClasses();
                if (classes2.length > 0) {
                    return classes2[0];
                }
                return null;
            }
            if (templateName.equals(DEFAULT_CLASS_TEMPLATE)) {
                aClass = JavaDirectoryService.getInstance().createClass(directory, rawClassName);
            } else {
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance((Project)project);
                FileTemplate fileTemplate = fileTemplateManager.getJ2eeTemplate(templateName);
                LOG.assertTrue(fileTemplate != null, (Object)(templateName + " not found"));
                String text2 = fileTemplate.getText(attributes);
                aClass = JavaCreateFromTemplateHandler.createClassOrInterface(project, directory, text2, true, fileTemplate.getExtension());
            }
            return (PsiClass)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)aClass);
        }
        catch (IOException e) {
            throw new IncorrectOperationException((Throwable)e);
        }
    }

    @NotNull
    private static PsiDirectory createParentDirectories(@NotNull PsiDirectory directoryRoot, @NotNull String className2) throws IncorrectOperationException {
        PsiPackage currentPackage = JavaDirectoryService.getInstance().getPackage(directoryRoot);
        String packagePrefix = currentPackage == null ? null : currentPackage.getQualifiedName() + ".";
        String packageName = CreateClassUtil.extractPackage(packagePrefix != null && className2.startsWith(packagePrefix) ? className2.substring(packagePrefix.length()) : className2);
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (tokenizer.hasMoreTokens()) {
            String packagePart = tokenizer.nextToken();
            PsiDirectory subdirectory = directoryRoot.findSubdirectory(packagePart);
            if (subdirectory == null) {
                directoryRoot.checkCreateSubdirectory(packagePart);
                subdirectory = directoryRoot.createSubdirectory(packagePart);
            }
            directoryRoot = subdirectory;
        }
        return directoryRoot;
    }

    public static String extractClassName(String fqName) {
        return StringUtil.getShortName((String)fqName);
    }

    public static String extractPackage(String fqName) {
        int i = fqName.lastIndexOf(46);
        return i == -1 ? "" : fqName.substring(0, i);
    }

    public static String makeFQName(String aPackage, String className2) {
        String fq = aPackage;
        if (!"".equals(aPackage)) {
            fq = fq + ".";
        }
        fq = fq + className2;
        return fq;
    }

    @Nullable
    public static PsiClass createClassNamed(String newClassName, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        return CreateClassUtil.createClassNamed(newClassName, FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties(), templateName, directory);
    }

    @Nullable
    public static PsiClass createClassWithDefaultProperties(String newClassName, Properties classProperties, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        Properties defaultProperties = FileTemplateManager.getInstance((Project)directory.getProject()).getDefaultProperties();
        Properties properties = new Properties(defaultProperties);
        properties.putAll((Map<?, ?>)classProperties);
        return CreateClassUtil.createClassNamed(newClassName, properties, templateName, directory);
    }

    @Nullable
    private static PsiClass createClassNamed(@Nullable String newClassName, @NotNull Properties properties, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        if (newClassName == null) {
            return null;
        }
        String className2 = CreateClassUtil.extractClassName(newClassName);
        properties.setProperty(CLASS_NAME_PROPERTY, className2);
        properties.setProperty(INTERFACE_NAME_PROPERTY, className2);
        return CreateClassUtil.createClassFromTemplate(properties, templateName, directory, newClassName);
    }

    @Nullable
    public static PsiClass createClassFromCustomTemplate(@Nullable PsiDirectory classDirectory, @Nullable Module module, String className2, String templateName) {
        if (classDirectory == null && module != null) {
            try {
                classDirectory = PackageUtil.findOrCreateDirectoryForPackage(module, "", null, false);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        if (classDirectory == null) {
            return null;
        }
        try {
            Properties properties = FileTemplateManager.getInstance((Project)classDirectory.getProject()).getDefaultProperties();
            return CreateClassUtil.createClassNamed(className2, new Properties(properties), templateName, classDirectory);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

