/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettingsFacade;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.SourceJavaCodeReference;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.VariableResolverProcessor;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.scope.DelegatingScopeProcessor;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.CharTable;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiReferenceExpressionImpl
extends ExpressionPsiElement
implements PsiReferenceExpression,
SourceJavaCodeReference {
    private static final Logger LOG = Logger.getInstance(PsiReferenceExpressionImpl.class);
    private volatile String myCachedQName;
    private volatile String myCachedNormalizedText;
    private static final Function<PsiReferenceExpressionImpl, PsiType> TYPE_EVALUATOR = new TypeEvaluator();

    public PsiReferenceExpressionImpl() {
        super(JavaElementType.REFERENCE_EXPRESSION);
    }

    public PsiExpression getQualifierExpression() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(54);
    }

    public PsiElement bindToElementViaStaticImport(@NotNull PsiClass qualifierClass) throws IncorrectOperationException {
        boolean doImportStatic;
        String qualifiedName = qualifierClass.getQualifiedName();
        if (qualifiedName == null) {
            throw new IncorrectOperationException();
        }
        if (this.getQualifierExpression() != null) {
            throw new IncorrectOperationException("Reference is qualified: " + this.getText());
        }
        if (!this.isPhysical()) {
            return this;
        }
        String staticName = this.getReferenceName();
        PsiFile containingFile = this.getContainingFile();
        PsiImportList importList = null;
        if (containingFile instanceof PsiJavaFile) {
            String qName;
            importList = ((PsiJavaFile)containingFile).getImportList();
            assert (importList != null) : containingFile;
            PsiImportStatementBase singleImportStatement = importList.findSingleImportStatement(staticName);
            boolean bl = doImportStatic = singleImportStatement == null;
            if (singleImportStatement instanceof PsiImportStaticStatement && (qName = qualifierClass.getQualifiedName() + "." + staticName).equals(singleImportStatement.getImportReference().getQualifiedName())) {
                return this;
            }
        } else {
            doImportStatic = false;
        }
        if (doImportStatic) {
            PsiReferenceExpressionImpl.bindToElementViaStaticImport(qualifierClass, staticName, importList);
        } else {
            PsiManagerEx manager = this.getManager();
            PsiReferenceExpression classRef = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createReferenceExpression(qualifierClass);
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
            LeafElement dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)manager);
            this.addInternal((TreeElement)dot, (ASTNode)dot, SourceTreeToPsiMap.psiElementToTree((PsiElement)this.getParameterList()), Boolean.TRUE);
            this.addBefore((PsiElement)classRef, SourceTreeToPsiMap.treeElementToPsi((ASTNode)dot));
        }
        return this;
    }

    public static void bindToElementViaStaticImport(@NotNull PsiClass qualifierClass, @NotNull String staticName, @NotNull PsiImportList importList) throws IncorrectOperationException {
        String qualifiedName = qualifierClass.getQualifiedName();
        List<PsiJavaCodeReferenceElement> refs = PsiReferenceExpressionImpl.getImportsFromClass(importList, qualifiedName);
        JavaCodeStyleSettingsFacade javaCodeStyleSettingsFacade = JavaCodeStyleSettingsFacade.getInstance((Project)qualifierClass.getProject());
        if (!javaCodeStyleSettingsFacade.isToImportInDemand(qualifiedName) && refs.size() + 1 < javaCodeStyleSettingsFacade.getNamesCountToUseImportOnDemand() || JavaCodeStyleManager.getInstance((Project)qualifierClass.getProject()).hasConflictingOnDemandImport((PsiJavaFile)importList.getContainingFile(), qualifierClass, staticName)) {
            importList.add((PsiElement)JavaPsiFacade.getElementFactory((Project)qualifierClass.getProject()).createImportStaticStatement(qualifierClass, staticName));
        } else {
            for (PsiJavaCodeReferenceElement ref : refs) {
                PsiImportStaticStatement importStatement = (PsiImportStaticStatement)PsiTreeUtil.getParentOfType((PsiElement)ref, PsiImportStaticStatement.class);
                if (importStatement == null) continue;
                importStatement.delete();
            }
            importList.add((PsiElement)JavaPsiFacade.getElementFactory((Project)qualifierClass.getProject()).createImportStaticStatement(qualifierClass, "*"));
        }
    }

    @NotNull
    private static List<PsiJavaCodeReferenceElement> getImportsFromClass(@NotNull PsiImportList importList, String className2) {
        ArrayList<PsiJavaCodeReferenceElement> array = new ArrayList<PsiJavaCodeReferenceElement>();
        for (PsiImportStaticStatement staticStatement : importList.getImportStaticStatements()) {
            PsiClass psiClass = staticStatement.resolveTargetClass();
            if (psiClass == null || !Comparing.strEqual((String)psiClass.getQualifiedName(), (String)className2)) continue;
            array.add(staticStatement.getImportReference());
        }
        return array;
    }

    public void setQualifierExpression(@Nullable PsiExpression newQualifier) throws IncorrectOperationException {
        PsiExpression oldQualifier = this.getQualifierExpression();
        if (newQualifier == null) {
            if (oldQualifier != null) {
                this.deleteChildInternal(oldQualifier.getNode());
            }
        } else {
            if (oldQualifier == null) {
                CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
                TreeElement dot = (TreeElement)this.findChildByRole(55);
                if (dot == null) {
                    dot = Factory.createSingleLeafElement((IElementType)JavaTokenType.DOT, (CharSequence)".", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    dot = this.addInternal(dot, (ASTNode)dot, (ASTNode)this.getFirstChildNode(), Boolean.TRUE);
                }
                this.addBefore((PsiElement)newQualifier, dot.getPsi());
            }
            this.getQualifierExpression().replace((PsiElement)newQualifier);
        }
    }

    @Override
    public PsiElement getQualifier() {
        return this.getQualifierExpression();
    }

    public String getReferenceName() {
        PsiElement element = this.getReferenceNameElement();
        return element != null ? element.getText() : null;
    }

    public void clearCaches() {
        this.myCachedQName = null;
        this.myCachedNormalizedText = null;
        super.clearCaches();
    }

    private JavaResolveResult @NotNull [] resolve(IElementType parentType, @NotNull PsiFile containingFile) {
        if (parentType == JavaElementType.REFERENCE_EXPRESSION) {
            PsiElement classNameElement;
            JavaResolveResult[] variable = null;
            JavaResolveResult[] result = this.resolveToVariable(containingFile);
            if (result.length == 1) {
                if (result[0].isAccessible()) {
                    return result;
                }
                variable = result;
            }
            if (!((classNameElement = this.getReferenceNameElement()) instanceof PsiIdentifier)) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
            result = this.resolveToClass(classNameElement, containingFile);
            if (result.length == 1 && !result[0].isAccessible()) {
                JavaResolveResult[] packageResult = this.resolveToPackage(containingFile);
                if (packageResult.length != 0) {
                    result = packageResult;
                }
            } else if (result.length == 0) {
                result = this.resolveToPackage(containingFile);
            }
            if (result.length == 0 && variable == null) {
                result = PsiJavaCodeReferenceElementImpl.tryClassResult(this.getCachedNormalizedText(), (PsiJavaCodeReferenceElement)this);
            }
            return result.length == 0 && variable != null ? variable : result;
        }
        if (parentType == JavaElementType.METHOD_CALL_EXPRESSION) {
            return this.resolveToMethod(containingFile);
        }
        if (parentType == JavaElementType.METHOD_REF_EXPRESSION) {
            if (((PsiMethodReferenceExpression)this.getParent()).isConstructor()) {
                PsiElement classNameElement = this.getReferenceNameElement();
                if (classNameElement == null) {
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                return this.resolveToClass(classNameElement, containingFile);
            }
            return this.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
        }
        return this.resolveToVariable(containingFile);
    }

    private JavaResolveResult @NotNull [] resolveToMethod(@NotNull PsiFile containingFile) {
        PsiMethodCallExpression methodCall = (PsiMethodCallExpression)this.getParent();
        MethodResolverProcessor processor2 = new MethodResolverProcessor(methodCall, containingFile);
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, (PsiCallExpression)methodCall, false);
        }
        catch (MethodProcessorSetupFailedException e) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return processor2.getResult();
    }

    private JavaResolveResult @NotNull [] resolveToPackage(@NotNull PsiFile containingFile) {
        String packageName = this.getCachedNormalizedText();
        Project project = containingFile.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        PsiPackage aPackage = psiFacade.findPackage(packageName);
        if (aPackage == null) {
            return psiFacade.isPartOfPackagePrefix(packageName) ? CandidateInfo.RESOLVE_RESULT_FOR_PACKAGE_PREFIX_PACKAGE : JavaResolveResult.EMPTY_ARRAY;
        }
        PsiExpression qualifier = this.getQualifierExpression();
        if (qualifier instanceof PsiReferenceExpression && !(((PsiReferenceExpression)qualifier).resolve() instanceof PsiPackage)) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        return new JavaResolveResult[]{new CandidateInfo((PsiElement)aPackage, PsiSubstitutor.EMPTY, (PsiElement)this, false)};
    }

    private JavaResolveResult @NotNull [] resolveToClass(@NotNull PsiElement classNameElement, @NotNull PsiFile containingFile) {
        String className2 = classNameElement.getText();
        ClassResolverProcessor processor2 = new ClassResolverProcessor(className2, (PsiElement)this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)this, null);
        return processor2.getResult();
    }

    private JavaResolveResult @NotNull [] resolveToVariable(@NotNull PsiFile containingFile) {
        VariableResolverProcessor processor2 = new VariableResolverProcessor((PsiJavaCodeReferenceElement)this, containingFile);
        PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)this, null);
        return processor2.getResult();
    }

    public JavaResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        return PsiImplUtil.multiResolveImpl(this, incompleteCode, OurGenericsResolver.INSTANCE);
    }

    @NotNull
    public String getCanonicalText() {
        String fqn;
        PsiElement element = this.resolve();
        if (element instanceof PsiClass && (fqn = ((PsiClass)element).getQualifiedName()) != null) {
            return fqn;
        }
        return this.getCachedNormalizedText();
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, TYPE_EVALUATOR);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        PsiElement parent;
        boolean parentIsMethodCall;
        IElementType i = this.getLastChildNode().getElementType();
        boolean resolvingToMethod = element instanceof PsiMethod;
        if (i == JavaTokenType.IDENTIFIER) {
            if (!(element instanceof PsiPackage)) {
                if (!(element instanceof PsiNamedElement)) {
                    return false;
                }
                String name2 = ((PsiNamedElement)element).getName();
                if (name2 == null) {
                    return false;
                }
                if (!name2.equals(this.getLastChildNode().getText())) {
                    return false;
                }
            }
        } else if (i == JavaTokenType.SUPER_KEYWORD || i == JavaTokenType.THIS_KEYWORD) {
            if (!resolvingToMethod) {
                return false;
            }
            if (!((PsiMethod)element).isConstructor()) {
                return false;
            }
        }
        if ((parentIsMethodCall = (parent = this.getParent()) instanceof PsiMethodCallExpression) != resolvingToMethod) {
            return false;
        }
        return element.getManager().areElementsEquivalent(element, this.advancedResolve(true).getElement());
    }

    public boolean isSoft() {
        return false;
    }

    public void processVariants(@NotNull PsiScopeProcessor processor2) {
        DelegatingScopeProcessor filterProcessor = new DelegatingScopeProcessor(processor2){
            private PsiElement myResolveContext;
            private final Set<String> myVarNames;
            {
                this.myVarNames = new THashSet();
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                return !this.shouldProcess(element) || super.execute(element, state);
            }

            private boolean shouldProcess(@NotNull PsiElement element) {
                if (element instanceof PsiVariable) {
                    return this.ensureNonShadowedVariable((PsiVariable)element);
                }
                if (element instanceof PsiClass) {
                    return !PsiReferenceExpressionImpl.seemsScrambled((PsiClass)element);
                }
                if (element instanceof PsiPackage) {
                    return PsiReferenceExpressionImpl.this.isQualified();
                }
                if (element instanceof PsiMethod) {
                    return this.shouldProcessMethod((PsiMethod)element);
                }
                return false;
            }

            private boolean ensureNonShadowedVariable(@NotNull PsiVariable element) {
                if (PsiUtil.isJvmLocalVariable((PsiElement)element)) {
                    this.myVarNames.add(element.getName());
                }
                return !(element instanceof PsiField) || !this.myVarNames.contains(element.getName());
            }

            private boolean shouldProcessMethod(@NotNull PsiMethod method) {
                PsiReferenceExpressionImpl ref = PsiReferenceExpressionImpl.this;
                return !method.isConstructor() && PsiReferenceExpressionImpl.hasValidQualifier(method, ref, this.myResolveContext);
            }

            public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
                if (event == JavaScopeProcessorEvent.SET_CURRENT_FILE_CONTEXT) {
                    this.myResolveContext = (PsiElement)associated;
                }
                super.handleEvent(event, associated);
            }
        };
        PsiScopesUtil.resolveAndWalk((PsiScopeProcessor)filterProcessor, (PsiJavaCodeReferenceElement)this, null, true);
    }

    @NotNull
    public JavaResolveResult advancedResolve(boolean incompleteCode) {
        JavaResolveResult[] results = this.multiResolve(incompleteCode);
        return results.length == 1 ? results[0] : JavaResolveResult.EMPTY;
    }

    private static boolean hasValidQualifier(@NotNull PsiMethod method, @NotNull PsiReferenceExpression ref, PsiElement scope) {
        PsiClass containingClass = method.getContainingClass();
        if (containingClass != null && containingClass.isInterface() && method.hasModifierProperty("static")) {
            if (!PsiUtil.getLanguageLevel((PsiElement)ref).isAtLeast(LanguageLevel.JDK_1_8)) {
                return false;
            }
            PsiExpression qualifierExpression2 = ref.getQualifierExpression();
            if (qualifierExpression2 == null && (scope instanceof PsiImportStaticStatement || PsiTreeUtil.isAncestor((PsiElement)containingClass, (PsiElement)ref, (boolean)true))) {
                return true;
            }
            if (qualifierExpression2 instanceof PsiReferenceExpression) {
                PsiElement resolve2 = ((PsiReferenceExpression)qualifierExpression2).resolve();
                if (containingClass.getManager().areElementsEquivalent(resolve2, (PsiElement)containingClass)) {
                    return true;
                }
                if (resolve2 instanceof PsiTypeParameter) {
                    HashSet<PsiClass> classes2 = new HashSet<PsiClass>();
                    for (PsiClassType type2 : ((PsiTypeParameter)resolve2).getExtendsListTypes()) {
                        PsiClass aClass = type2.resolve();
                        if (aClass == null) continue;
                        classes2.add(aClass);
                    }
                    if (classes2.size() == 1 && classes2.contains(containingClass)) {
                        return true;
                    }
                }
            }
            return false;
        }
        return true;
    }

    public static boolean seemsScrambled(@Nullable PsiClass aClass) {
        return aClass instanceof PsiCompiledElement && PsiReferenceExpressionImpl.seemsScrambledByStructure(aClass);
    }

    @VisibleForTesting
    public static boolean seemsScrambledByStructure(@NotNull PsiClass aClass) {
        PsiClass containingClass = aClass.getContainingClass();
        if (containingClass != null && !PsiReferenceExpressionImpl.seemsScrambledByStructure(containingClass)) {
            return false;
        }
        if (PsiReferenceExpressionImpl.seemsScrambled(aClass.getName())) {
            List methods = ContainerUtil.filter((Object[])aClass.getMethods(), method -> !method.hasModifierProperty("private"));
            return !methods.isEmpty() && ContainerUtil.and((Iterable)methods, method -> PsiReferenceExpressionImpl.seemsScrambled(method.getName()));
        }
        return false;
    }

    private static boolean seemsScrambled(String name2) {
        return name2 != null && !name2.isEmpty() && name2.length() <= 2;
    }

    public PsiElement getReferenceNameElement() {
        return this.findChildByRoleAsPsiElement(53);
    }

    public PsiReferenceParameterList getParameterList() {
        return (PsiReferenceParameterList)PsiTreeUtil.getChildOfType((PsiElement)this, PsiReferenceParameterList.class);
    }

    public PsiType @NotNull [] getTypeParameters() {
        PsiReferenceParameterList parameterList = this.getParameterList();
        return parameterList != null ? parameterList.getTypeArguments() : PsiType.EMPTY_ARRAY;
    }

    public int getTextOffset() {
        ASTNode refName = this.findChildByRole(53);
        return refName == null ? super.getTextOffset() : refName.getStartOffset();
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        if (this.getQualifierExpression() != null) {
            return this.renameDirectly(newElementName);
        }
        JavaResolveResult resolveResult = this.advancedResolve(false);
        if (resolveResult.getElement() == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElement currentFileResolveScope = resolveResult.getCurrentFileResolveScope();
        if (!(currentFileResolveScope instanceof PsiImportStaticStatement) || ((PsiImportStaticStatement)currentFileResolveScope).isOnDemand()) {
            return this.renameDirectly(newElementName);
        }
        PsiImportStaticStatement importStaticStatement = (PsiImportStaticStatement)currentFileResolveScope;
        String referenceName = importStaticStatement.getReferenceName();
        LOG.assertTrue(referenceName != null);
        PsiElement element = importStaticStatement.getImportReference().resolve();
        if (this.getManager().areElementsEquivalent(element, resolveResult.getElement())) {
            return this.renameDirectly(newElementName);
        }
        PsiClass psiClass = importStaticStatement.resolveTargetClass();
        if (psiClass == null) {
            return this.renameDirectly(newElementName);
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)this.getProject());
        PsiReferenceExpression expression2 = (PsiReferenceExpression)factory.createExpressionFromText("X." + newElementName, (PsiElement)this);
        PsiReferenceExpression result = (PsiReferenceExpression)this.replace((PsiElement)expression2);
        ((PsiReferenceExpression)result.getQualifierExpression()).bindToElement((PsiElement)psiClass);
        return result;
    }

    @NotNull
    private PsiElement renameDirectly(@NotNull String newElementName) throws IncorrectOperationException {
        PsiElement oldIdentifier = this.findChildByRoleAsPsiElement(53);
        if (oldIdentifier == null) {
            throw new IncorrectOperationException();
        }
        String oldRefName = oldIdentifier.getText();
        if ("this".equals(oldRefName) || "super".equals(oldRefName) || newElementName.equals(oldRefName)) {
            return this;
        }
        PsiIdentifier identifier = JavaPsiFacade.getElementFactory((Project)this.getProject()).createIdentifier(newElementName);
        oldIdentifier.replace((PsiElement)identifier);
        return this;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        CheckUtil.checkWritable((PsiElement)this);
        if (this.isReferenceTo(element)) {
            return this;
        }
        PsiManagerEx manager = this.getManager();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiJavaParserFacade parserFacade = facade.getParserFacade();
        if (element instanceof PsiClass) {
            boolean preserveQualification = JavaCodeStyleSettingsFacade.getInstance((Project)this.getProject()).useFQClassNames() && PsiReferenceExpressionImpl.isFullyQualified((CompositeElement)this);
            String qName = ((PsiClass)element).getQualifiedName();
            if (qName == null) {
                qName = ((PsiClass)element).getName();
            } else {
                if (JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(qName, this.getResolveScope()) == null && !preserveQualification) {
                    return this;
                }
                if (facade.getResolveHelper().resolveReferencedClass(qName, (PsiElement)this) == null && facade.getResolveHelper().resolveReferencedClass(StringUtil.getPackageName((String)qName), (PsiElement)this) != null) {
                    qName = ((PsiClass)element).getName();
                    assert (qName != null) : element;
                }
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)manager.getProject());
            if (!preserveQualification) {
                ref = (PsiExpression)codeStyleManager.shortenClassReferences((PsiElement)ref, 8192);
            }
            return ref;
        }
        if (element instanceof PsiPackage) {
            String qName = ((PsiPackage)element).getQualifiedName();
            if (qName.isEmpty()) {
                throw new IncorrectOperationException();
            }
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            return ref;
        }
        if ((element instanceof PsiField || element instanceof PsiMethod) && ((PsiMember)element).hasModifierProperty("static")) {
            if (!this.isPhysical()) {
                return this;
            }
            PsiMember member = (PsiMember)element;
            PsiClass psiClass = member.getContainingClass();
            if (psiClass == null) {
                throw new IncorrectOperationException();
            }
            String qName = psiClass.getQualifiedName() + "." + member.getName();
            PsiExpression ref = parserFacade.createExpressionFromText(qName, (PsiElement)this);
            this.getTreeParent().replaceChildInternal((ASTNode)this, (TreeElement)ref.getNode());
            return ref;
        }
        throw new IncorrectOperationException(element.toString());
    }

    private static boolean isFullyQualified(@NotNull CompositeElement classRef) {
        ASTNode qualifier;
        while ((qualifier = classRef.findChildByRole(54)) != null) {
            if (qualifier.getElementType() != JavaElementType.REFERENCE_EXPRESSION) {
                return false;
            }
            PsiElement refElement = ((PsiReference)qualifier).resolve();
            if (refElement instanceof PsiPackage) {
                return true;
            }
            classRef = (CompositeElement)qualifier;
        }
        return false;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (this.getChildRole(child) == 54) {
            ASTNode start;
            ASTNode dot = this.findChildByType(JavaTokenType.DOT, child);
            assert (dot != null) : this;
            this.deleteChildRange(child.getPsi(), dot.getPsi());
            TreeElement first = this.getFirstChildNode();
            if (this.getChildRole((ASTNode)first) == 246 && first.getFirstChildNode() == null && PsiImplUtil.isWhitespaceOrComment(start = first.getTreeNext())) {
                ASTNode next = PsiImplUtil.skipWhitespaceAndComments(start);
                assert (next != null) : this;
                CodeEditUtil.removeChildren((ASTNode)this, (ASTNode)start, (ASTNode)next.getTreePrev());
            }
        } else if (child.getElementType() == JavaElementType.REFERENCE_PARAMETER_LIST) {
            this.replaceChildInternal(child, PsiReferenceExpressionImpl.createEmptyRefParameterList(this.getProject()));
        } else {
            super.deleteChildInternal(child);
        }
    }

    @NotNull
    public static TreeElement createEmptyRefParameterList(@NotNull Project project) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        return (TreeElement)Objects.requireNonNull(factory.createReferenceFromText("foo", null).getParameterList()).getNode();
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            case 53: {
                TreeElement lastChild = this.getLastChildNode();
                return lastChild == null || this.getChildRole((ASTNode)lastChild) == role ? lastChild : this.findChildByType(JavaTokenType.IDENTIFIER);
            }
            case 54: {
                TreeElement firstChild = this.getFirstChildNode();
                return firstChild != null && this.getChildRole((ASTNode)firstChild) == 54 ? firstChild : null;
            }
            case 246: {
                return this.findChildByType(JavaElementType.REFERENCE_PARAMETER_LIST);
            }
            case 55: {
                return this.findChildByType(JavaTokenType.DOT);
            }
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.DOT) {
            return 55;
        }
        if (i == JavaElementType.REFERENCE_PARAMETER_LIST) {
            return 246;
        }
        if (i == JavaTokenType.IDENTIFIER || i == JavaTokenType.THIS_KEYWORD || i == JavaTokenType.SUPER_KEYWORD) {
            return 53;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 54;
        }
        return 0;
    }

    public PsiReference getReference() {
        return this.getReferenceNameElement() != null ? this : null;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitReferenceExpression((PsiReferenceExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    @NotNull
    public PsiElement getElement() {
        return this;
    }

    @NotNull
    public TextRange getRangeInElement() {
        return PsiJavaCodeReferenceElementImpl.calcRangeInElement(this);
    }

    public PsiElement resolve() {
        return this.advancedResolve(false).getElement();
    }

    @Override
    @NotNull
    public String getClassNameText() {
        String cachedQName = this.myCachedQName;
        if (cachedQName == null) {
            this.myCachedQName = cachedQName = PsiNameHelper.getQualifiedClassName((String)this.getCachedNormalizedText(), (boolean)false);
        }
        return cachedQName;
    }

    @Override
    public void fullyQualify(@NotNull PsiClass targetClass) {
        JavaSourceUtil.fullyQualifyReference((CompositeElement)this, targetClass);
    }

    @Override
    public boolean isQualified() {
        return this.getChildRole((ASTNode)this.getFirstChildNode()) == 54;
    }

    @NotNull
    public String getQualifiedName() {
        return this.getCanonicalText();
    }

    @NotNull
    private String getCachedNormalizedText() {
        String whiteSpaceAndComments = this.myCachedNormalizedText;
        if (whiteSpaceAndComments == null) {
            this.myCachedNormalizedText = whiteSpaceAndComments = JavaSourceUtil.getReferenceText((PsiJavaCodeReferenceElement)this);
        }
        return whiteSpaceAndComments;
    }

    public String toString() {
        return "PsiReferenceExpression:" + this.getText();
    }

    private static class TypeEvaluator
    implements NullableFunction<PsiReferenceExpressionImpl, PsiType> {
        private TypeEvaluator() {
        }

        public PsiType fun(@NotNull PsiReferenceExpressionImpl expr2) {
            PsiElement resolve2;
            PsiFile file = expr2.getContainingFile();
            Project project = file.getProject();
            ResolveResult[] results = ResolveCache.getInstance((Project)project).resolveWithCaching((PsiPolyVariantReference)expr2, (ResolveCache.PolyVariantContextResolver)OurGenericsResolver.INSTANCE, true, false, file);
            JavaResolveResult result = results.length == 1 ? (JavaResolveResult)results[0] : null;
            PsiElement psiElement = resolve2 = result == null ? null : result.getElement();
            if (resolve2 == null) {
                PsiType type2;
                ASTNode qualifier;
                ASTNode refName = expr2.findChildByRole(53);
                if (refName != null && "length".equals(refName.getText()) && (qualifier = expr2.findChildByRole(54)) != null && ElementType.EXPRESSION_BIT_SET.contains(qualifier.getElementType()) && (type2 = ((PsiExpression)SourceTreeToPsiMap.treeToPsiNotNull((ASTNode)qualifier)).getType()) instanceof PsiArrayType) {
                    return PsiType.INT;
                }
                return null;
            }
            PsiMethod owner2 = null;
            PsiType ret = null;
            if (resolve2 instanceof PsiVariable) {
                PsiType type3 = ((PsiVariable)resolve2).getType();
                PsiType psiType = ret = type3 instanceof PsiEllipsisType ? ((PsiEllipsisType)type3).toArrayType() : type3;
                if (!ret.isValid()) {
                    PsiUtil.ensureValidType((PsiType)ret, (String)("invalid type of " + resolve2 + " of class " + resolve2.getClass() + ", valid=" + resolve2.isValid()));
                }
                if (resolve2 instanceof PsiField && !((PsiField)resolve2).hasModifierProperty("static")) {
                    owner2 = ((PsiField)resolve2).getContainingClass();
                }
            } else if (resolve2 instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)resolve2;
                ret = method.getReturnType();
                if (ret != null) {
                    PsiUtil.ensureValidType((PsiType)ret, (PsiElement)method);
                }
                owner2 = method;
            }
            if (ret == null) {
                return null;
            }
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5)) {
                PsiSubstitutor substitutor = result.getSubstitutor();
                if (owner2 == null || !PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)owner2, (PsiSubstitutor)substitutor)) {
                    PsiType substitutedType = substitutor.substitute(ret);
                    PsiUtil.ensureValidType((PsiType)substitutedType);
                    PsiType normalized = PsiImplUtil.normalizeWildcardTypeByPosition(substitutedType, (PsiExpression)expr2);
                    PsiUtil.ensureValidType((PsiType)normalized);
                    return PsiClassImplUtil.correctType(normalized, expr2.getResolveScope());
                }
            }
            return PsiClassImplUtil.correctType(TypeConversionUtil.erasure((PsiType)ret), expr2.getResolveScope());
        }
    }

    public static final class OurGenericsResolver
    implements ResolveCache.PolyVariantContextResolver<PsiJavaReference> {
        public static final OurGenericsResolver INSTANCE = new OurGenericsResolver();

        public ResolveResult @NotNull [] resolve(@NotNull PsiJavaReference ref, @NotNull PsiFile containingFile, boolean incompleteCode) {
            PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)ref;
            CompositeElement treeParent = expression2.getTreeParent();
            IElementType parentType = treeParent == null ? null : treeParent.getElementType();
            List<ResolveResult[]> qualifiers = OurGenericsResolver.resolveAllQualifiers(expression2, containingFile);
            JavaResolveResult[] result = expression2.resolve(parentType, containingFile);
            if (result.length == 0 && incompleteCode && parentType != JavaElementType.REFERENCE_EXPRESSION) {
                result = expression2.resolve(JavaElementType.REFERENCE_EXPRESSION, containingFile);
            }
            JavaResolveUtil.substituteResults((PsiJavaCodeReferenceElement)expression2, result);
            ObjectUtils.reachabilityFence(qualifiers);
            return result;
        }

        @NotNull
        private static List<ResolveResult[]> resolveAllQualifiers(@NotNull PsiReferenceExpressionImpl expression2, @NotNull PsiFile containingFile) {
            PsiElement qualifier = expression2.getQualifier();
            if (qualifier == null) {
                return Collections.emptyList();
            }
            SmartList qualifiers = new SmartList();
            final ResolveCache resolveCache = ResolveCache.getInstance((Project)containingFile.getProject());
            final boolean physical = containingFile.isPhysical();
            qualifier.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor((List)qualifiers, containingFile){
                final /* synthetic */ List val$qualifiers;
                final /* synthetic */ PsiFile val$containingFile;
                {
                    this.val$qualifiers = list;
                    this.val$containingFile = psiFile;
                }

                public void visitReferenceExpression(PsiReferenceExpression expression2) {
                    if (!(expression2 instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    ResolveResult[] cachedResults = resolveCache.getCachedResults((PsiPolyVariantReference)expression2, physical, false, true);
                    if (cachedResults != null) {
                        return;
                    }
                    this.visitElement((PsiElement)expression2);
                }

                protected void elementFinished(@NotNull PsiElement element) {
                    if (!(element instanceof PsiReferenceExpressionImpl)) {
                        return;
                    }
                    PsiReferenceExpressionImpl expression2 = (PsiReferenceExpressionImpl)element;
                    this.val$qualifiers.add(resolveCache.resolveWithCaching((PsiPolyVariantReference)expression2, (ResolveCache.PolyVariantContextResolver)INSTANCE, true, false, this.val$containingFile));
                }

                public void visitExpressionList(PsiExpressionList list) {
                }

                public void visitLambdaExpression(PsiLambdaExpression expression2) {
                }

                public void visitClass(PsiClass aClass) {
                }
            });
            return qualifiers;
        }
    }
}

