/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.codeInsight.daemon.impl.analysis.JavaGenericsUtil;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JavaVersionService;
import com.intellij.openapi.util.Comparing;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ThreadLocalTypes;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.impl.PsiClassImplUtil;
import com.intellij.psi.impl.source.resolve.JavaResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.Function;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiMethodCallExpressionImpl
extends ExpressionPsiElement
implements PsiMethodCallExpression {
    private static final Logger LOG = Logger.getInstance(PsiMethodCallExpressionImpl.class);
    private static final TypeEvaluator ourTypeEvaluator = new TypeEvaluator();

    public PsiMethodCallExpressionImpl() {
        super(JavaElementType.METHOD_CALL_EXPRESSION);
    }

    public PsiType getType() {
        return JavaResolveCache.getInstance(this.getProject()).getType(this, ourTypeEvaluator);
    }

    public PsiMethod resolveMethod() {
        return (PsiMethod)this.getMethodExpression().resolve();
    }

    @NotNull
    public JavaResolveResult resolveMethodGenerics() {
        return this.getMethodExpression().advancedResolve(false);
    }

    public void removeChild(@NotNull ASTNode child) {
        if (child == this.getArgumentList()) {
            LOG.error("Cannot delete argument list since it will break contract on argument list notnullity");
        }
        super.removeChild(child);
    }

    @NotNull
    public PsiReferenceParameterList getTypeArgumentList() {
        PsiReferenceExpression expression2 = this.getMethodExpression();
        PsiReferenceParameterList result = expression2.getParameterList();
        if (result != null) {
            return result;
        }
        LOG.error("Invalid method call expression. Children:\n" + DebugUtil.psiTreeToString((PsiElement)expression2, (boolean)false));
        return result;
    }

    public PsiType @NotNull [] getTypeArguments() {
        return this.getMethodExpression().getTypeParameters();
    }

    @NotNull
    public PsiReferenceExpression getMethodExpression() {
        return (PsiReferenceExpression)this.findChildByRoleAsPsiElement(91);
    }

    @NotNull
    public PsiExpressionList getArgumentList() {
        PsiExpressionList list = (PsiExpressionList)this.findChildByRoleAsPsiElement(73);
        if (list == null) {
            LOG.error("Invalid PSI for'" + this.getText() + ". Parent:" + DebugUtil.psiToString((PsiElement)this.getParent(), (boolean)false));
        }
        return list;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 91: {
                return this.getFirstChildNode();
            }
            case 73: 
        }
        return this.findChildByType(JavaElementType.EXPRESSION_LIST);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaElementType.EXPRESSION_LIST) {
            return 73;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 91;
        }
        return 0;
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitMethodCallExpression((PsiMethodCallExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiMethodCallExpression:" + this.getText();
    }

    public static boolean doWePerformGenericMethodOverloadResolutionNow(PsiCall call, LanguageLevel languageLevel) {
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp((PsiElement)call.getParent());
        PsiExpressionList parentArgList = languageLevel.isAtLeast(LanguageLevel.JDK_1_8) ? (callParent instanceof PsiConditionalExpression && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((PsiExpression)callParent)) ? null : (PsiExpressionList)PsiTreeUtil.getParentOfType((PsiElement)call, PsiExpressionList.class, (boolean)true, (Class[])new Class[]{PsiReferenceExpression.class})) : null;
        return parentArgList != null && MethodCandidateInfo.isOverloadCheck(parentArgList) && Arrays.stream(parentArgList.getExpressions()).map(expression2 -> PsiUtil.skipParenthesizedExprDown((PsiExpression)expression2)).noneMatch(expression2 -> expression2 != null && ThreadLocalTypes.hasBindingFor((PsiElement)expression2));
    }

    private static PsiType captureReturnType(PsiMethodCallExpression call, PsiMethod method, PsiType ret, JavaResolveResult result, LanguageLevel languageLevel) {
        PsiType erased;
        PsiSubstitutor substitutor = result.getSubstitutor();
        substitutor.ensureValid();
        PsiType substitutedReturnType = substitutor.substitute(ret);
        if (substitutedReturnType == null) {
            return TypeConversionUtil.erasure((PsiType)ret);
        }
        if (result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isErased()) {
            return TypeConversionUtil.erasure((PsiType)substitutedReturnType);
        }
        if (((!languageLevel.isAtLeast(LanguageLevel.JDK_1_8) || call.getTypeArguments().length > 0) && method.hasTypeParameters() || !method.hasTypeParameters() && JavaVersionService.getInstance().isAtLeast((PsiElement)call, JavaSdkVersion.JDK_1_8)) && !substitutedReturnType.equals(erased = TypeConversionUtil.erasure((PsiType)substitutedReturnType)) && result instanceof MethodCandidateInfo && ((MethodCandidateInfo)result).isApplicable()) {
            PsiType[] args = call.getArgumentList().getExpressionTypes();
            PsiParameter[] parameters2 = method.getParameterList().getParameters();
            boolean varargs = ((MethodCandidateInfo)result).getApplicabilityLevel() == 2;
            for (int i = 0; i < args.length; ++i) {
                PsiType parameterType = substitutor.substitute(PsiTypesUtil.getParameterType((PsiParameter[])parameters2, (int)i, (boolean)varargs));
                PsiType expressionType = args[i];
                if (expressionType == null || parameterType == null || !JavaGenericsUtil.isRawToGeneric((PsiType)parameterType, (PsiType)expressionType)) continue;
                return erased;
            }
        }
        if (PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)method, (PsiSubstitutor)substitutor)) {
            PsiType returnTypeErasure = TypeConversionUtil.erasure((PsiType)ret);
            if (Comparing.equal((Object)TypeConversionUtil.erasure((PsiType)substitutedReturnType), (Object)returnTypeErasure)) {
                return returnTypeErasure;
            }
        }
        return PsiUtil.captureToplevelWildcards((PsiType)substitutedReturnType, (PsiElement)call);
    }

    private static class TypeEvaluator
    implements Function<PsiMethodCallExpression, PsiType> {
        private TypeEvaluator() {
        }

        @Nullable
        public PsiType fun(PsiMethodCallExpression call) {
            PsiReferenceExpression methodExpression = call.getMethodExpression();
            JavaResolveResult[] results = methodExpression.multiResolve(false);
            PsiFile file = call.getContainingFile();
            LanguageLevel languageLevel = PsiUtil.getLanguageLevel((PsiElement)file);
            boolean genericParentOverloadResolution = PsiMethodCallExpressionImpl.doWePerformGenericMethodOverloadResolutionNow((PsiCall)call, languageLevel);
            PsiType theOnly = null;
            for (int i = 0; i < results.length; ++i) {
                PsiType type2;
                JavaResolveResult candidateInfo = results[i];
                PsiElement element = candidateInfo.getElement();
                if (genericParentOverloadResolution && element != null && PsiPolyExpressionUtil.isMethodCallPolyExpression((PsiExpression)call, (PsiMethod)((PsiMethod)element))) {
                    LOG.error("poly expression evaluation during overload resolution, processing " + results.length + " results");
                }
                if ((type2 = TypeEvaluator.getResultType(call, methodExpression, candidateInfo, languageLevel)) == null) {
                    return null;
                }
                if (i == 0) {
                    theOnly = type2;
                    continue;
                }
                if (theOnly.equals(type2)) continue;
                return null;
            }
            return PsiClassImplUtil.correctType(theOnly, file.getResolveScope());
        }

        @Nullable
        private static PsiType getResultType(@NotNull PsiMethodCallExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull JavaResolveResult result, @NotNull LanguageLevel languageLevel) {
            PsiMethod method = (PsiMethod)result.getElement();
            if (method == null) {
                return null;
            }
            PsiUtilCore.ensureValid((PsiElement)method);
            boolean is15OrHigher = languageLevel.compareTo((Enum)LanguageLevel.JDK_1_5) >= 0;
            PsiType getClassReturnType = PsiTypesUtil.patchMethodGetClassReturnType((PsiExpression)call, (PsiReferenceExpression)methodExpression, (PsiMethod)method, type2 -> type2 != JavaElementType.CLASS && type2 != JavaElementType.ANONYMOUS_CLASS, (LanguageLevel)languageLevel);
            if (getClassReturnType != null) {
                return getClassReturnType;
            }
            PsiType ret = method.getReturnType();
            if (ret == null) {
                return null;
            }
            PsiUtil.ensureValidType((PsiType)ret);
            if (ret instanceof PsiClassType) {
                ret = ((PsiClassType)ret).setLanguageLevel(languageLevel);
            }
            if (is15OrHigher) {
                return PsiMethodCallExpressionImpl.captureReturnType(call, method, ret, result, languageLevel);
            }
            return TypeConversionUtil.erasure((PsiType)ret);
        }
    }
}

