/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiPattern;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeTestPattern;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.java.ExpressionPsiElement;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PatternResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiInstanceOfExpressionImpl
extends ExpressionPsiElement
implements PsiInstanceOfExpression,
Constants {
    private static final Logger LOG = Logger.getInstance(PsiInstanceOfExpressionImpl.class);

    public PsiInstanceOfExpressionImpl() {
        super(INSTANCE_OF_EXPRESSION);
    }

    @NotNull
    public PsiExpression getOperand() {
        return (PsiExpression)this.findChildByRoleAsPsiElement(67);
    }

    public PsiTypeElement getCheckType() {
        PsiPattern pattern = this.getPattern();
        if (!(pattern instanceof PsiTypeTestPattern)) {
            return null;
        }
        return ((PsiTypeTestPattern)pattern).getCheckType();
    }

    public PsiType getType() {
        return PsiType.BOOLEAN;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 67: {
                return this.findChildByType(EXPRESSION_BIT_SET);
            }
            case 68: 
        }
        return this.findChildByType(INSTANCEOF_KEYWORD);
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == INSTANCEOF_KEYWORD) {
            return 68;
        }
        if (EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 67;
        }
        return 0;
    }

    @Nullable
    public PsiPattern getPattern() {
        return (PsiPattern)PsiTreeUtil.getChildOfType((PsiElement)this, PsiPattern.class);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitInstanceOfExpression((PsiInstanceOfExpression)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public boolean processDeclarations(@NotNull PsiScopeProcessor processor2, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (lastParent != null) {
            return true;
        }
        ElementClassHint elementClassHint = (ElementClassHint)processor2.getHint(ElementClassHint.KEY);
        if (elementClassHint != null && !elementClassHint.shouldProcess(ElementClassHint.DeclarationKind.VARIABLE)) {
            return true;
        }
        if (state.get(PatternResolveState.KEY) == PatternResolveState.WHEN_FALSE) {
            return true;
        }
        PsiPattern pattern = this.getPattern();
        if (pattern == null) {
            return true;
        }
        return pattern.processDeclarations(processor2, state, null, place);
    }

    public String toString() {
        return "PsiInstanceofExpression";
    }
}

