/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.CompositePsiElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.JavaSourceUtil;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;

public class PsiExpressionListImpl
extends CompositePsiElement
implements PsiExpressionList {
    private static final Logger LOG = Logger.getInstance(PsiExpressionListImpl.class);
    private volatile PsiExpression[] myExpressions;

    public PsiExpressionListImpl() {
        super(JavaElementType.EXPRESSION_LIST);
    }

    public PsiExpression @NotNull [] getExpressions() {
        PsiExpression[] expressions2 = this.myExpressions;
        if (expressions2 == null && (expressions2 = (PsiExpression[])this.getChildrenAsPsiElements(ElementType.EXPRESSION_BIT_SET, PsiExpression.ARRAY_FACTORY)).length > 10) {
            this.myExpressions = expressions2;
        }
        return expressions2;
    }

    public void clearCaches() {
        super.clearCaches();
        this.myExpressions = null;
    }

    public int getExpressionCount() {
        PsiExpression[] expressions2 = this.myExpressions;
        if (expressions2 != null) {
            return expressions2.length;
        }
        return this.countChildren(ElementType.EXPRESSION_BIT_SET);
    }

    public boolean isEmpty() {
        return this.findChildByType(ElementType.EXPRESSION_BIT_SET) == null;
    }

    public PsiType @NotNull [] getExpressionTypes() {
        PsiExpression[] expressions2 = this.getExpressions();
        PsiType[] types = PsiType.createArray((int)expressions2.length);
        for (int i = 0; i < types.length; ++i) {
            types[i] = expressions2[i].getType();
        }
        return types;
    }

    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                return this.getFirstChildNode() != null && this.getFirstChildNode().getElementType() == JavaTokenType.LPARENTH ? this.getFirstChildNode() : null;
            }
            case 25: 
        }
        if (this.getLastChildNode() != null && this.getLastChildNode().getElementType() == JavaTokenType.RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    public int getChildRole(@NotNull ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == JavaTokenType.COMMA) {
            return 23;
        }
        if (i == JavaTokenType.LPARENTH) {
            return 24;
        }
        if (i == JavaTokenType.RPARENTH) {
            return 25;
        }
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            return 59;
        }
        return 0;
    }

    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        CharTable treeCharTab = SharedImplUtil.findCharTableByTree((ASTNode)this);
        if (anchor == null) {
            LeafElement rparenth;
            LeafElement lparenth;
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.LPARENTH, (CharSequence)"(", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)lparenth, (ASTNode)lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.RPARENTH, (CharSequence)")", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)rparenth, (ASTNode)rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(25);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                if (anchor == null) {
                    lparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.LPARENTH, (CharSequence)"(", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)lparenth, (ASTNode)lparenth, null, Boolean.FALSE);
                    rparenth = Factory.createSingleLeafElement((IElementType)JavaTokenType.RPARENTH, (CharSequence)")", (int)0, (int)1, (CharTable)treeCharTab, (PsiManager)this.getManager());
                    super.addInternal((TreeElement)rparenth, (ASTNode)rparenth, null, Boolean.TRUE);
                    anchor = this.findChildByRole(24);
                    LOG.assertTrue(anchor != null);
                }
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        TreeElement element = first;
        while (true) {
            if (ElementType.EXPRESSION_BIT_SET.contains(element.getElementType())) {
                JavaSourceUtil.addSeparatingComma((CompositeElement)this, (ASTNode)element, ElementType.EXPRESSION_BIT_SET);
                break;
            }
            if (element == last) break;
            element = element.getTreeNext();
        }
        return firstAdded;
    }

    public void deleteChildInternal(@NotNull ASTNode child) {
        if (ElementType.EXPRESSION_BIT_SET.contains(child.getElementType())) {
            JavaSourceUtil.deleteSeparatingComma((CompositeElement)this, child);
        }
        super.deleteChildInternal(child);
    }

    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitExpressionList((PsiExpressionList)this);
        } else {
            visitor2.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiExpressionList";
    }
}

