/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class StringLiteralManipulator
extends AbstractElementManipulator<PsiLiteralExpression> {
    public PsiLiteralExpression handleContentChange(@NotNull PsiLiteralExpression expr2, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        String oldText = expr2.getText();
        if (oldText.startsWith("\"")) {
            newContent = StringUtil.escapeStringCharacters((String)newContent);
        } else if (oldText.startsWith("'") && newContent.length() <= 1) {
            newContent = newContent.length() == 1 && newContent.charAt(0) == '\'' ? "\\'" : newContent;
        } else {
            throw new IncorrectOperationException("cannot handle content change for: " + oldText + ", expr: " + expr2);
        }
        String newText = oldText.substring(0, range.getStartOffset()) + newContent + oldText.substring(range.getEndOffset());
        PsiExpression newExpr = JavaPsiFacade.getElementFactory((Project)expr2.getProject()).createExpressionFromText(newText, null);
        return (PsiLiteralExpression)expr2.replace((PsiElement)newExpr);
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiLiteralExpression element) {
        return StringLiteralManipulator.getValueRange(element);
    }

    @NotNull
    public static TextRange getValueRange(@NotNull PsiLiteralExpression expression2) {
        int length = expression2.getTextLength();
        if (expression2.isTextBlock()) {
            String text2 = expression2.getText();
            int startOffset = StringLiteralManipulator.findBlockStart(text2);
            return startOffset < 0 ? new TextRange(0, length) : new TextRange(startOffset, length - (text2.endsWith("\"\"\"") ? 3 : 0));
        }
        PsiType type2 = expression2.getType();
        boolean isQuoted = PsiType.CHAR.equals((Object)type2) || type2 != null && type2.equalsToText("java.lang.String");
        return isQuoted ? new TextRange(1, Math.max(1, length - 1)) : TextRange.from((int)0, (int)length);
    }

    private static int findBlockStart(String text2) {
        if (!text2.startsWith("\"\"\"")) {
            return -1;
        }
        int length = text2.length();
        for (int i = 3; i < length; ++i) {
            char c = text2.charAt(i);
            if (c == '\n') {
                return i + 1;
            }
            if (Character.isWhitespace(c)) continue;
            return -1;
        }
        return -1;
    }
}

