/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.reference.impl.JavaReflectionReferenceUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaLangClassMemberReference
extends PsiReferenceBase<PsiLiteralExpression>
implements InsertHandler<LookupElement> {
    private final PsiExpression myContext;

    public JavaLangClassMemberReference(@NotNull PsiLiteralExpression literal, @NotNull PsiExpression context) {
        super((PsiElement)literal);
        this.myContext = context;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        return element;
    }

    public PsiElement resolve() {
        Object value2 = ((PsiLiteralExpression)this.myElement).getValue();
        if (value2 instanceof String) {
            JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
            String name2 = (String)value2;
            String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
            if (type2 != null && (ownerClass = this.getOwnerClass()) != null) {
                switch (type2) {
                    case "getField": {
                        return ownerClass.getPsiClass().findFieldByName(name2, true);
                    }
                    case "getDeclaredField": {
                        PsiField field = ownerClass.getPsiClass().findFieldByName(name2, false);
                        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, ownerClass) ? field : null;
                    }
                    case "getMethod": {
                        Object[] methods = ownerClass.getPsiClass().findMethodsByName(name2, true);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaReflectionReferenceUtil.isPublic((PsiMember)method)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                    case "getDeclaredMethod": {
                        Object[] methods = ownerClass.getPsiClass().findMethodsByName(name2, false);
                        if (methods.length > 1 && (methods = ContainerUtil.filter((Object[])methods, method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, ownerClass)).toArray(PsiMethod.EMPTY_ARRAY)).length > 1) {
                            return this.findOverloadedMethod((PsiMethod[])methods);
                        }
                        return methods.length != 0 ? methods[0] : null;
                    }
                    case "newUpdater": {
                        return ownerClass.getPsiClass().findFieldByName(name2, false);
                    }
                }
            }
        }
        return null;
    }

    @Nullable
    private JavaReflectionReferenceUtil.ReflectiveClass getOwnerClass() {
        return JavaReflectionReferenceUtil.getReflectiveClass(this.myContext);
    }

    public Object @NotNull [] getVariants() {
        JavaReflectionReferenceUtil.ReflectiveClass ownerClass;
        String type2 = JavaReflectionReferenceUtil.getMemberType(this.myElement);
        if (type2 != null && (ownerClass = this.getOwnerClass()) != null) {
            switch (type2) {
                case "getDeclaredField": {
                    return Arrays.stream(ownerClass.getPsiClass().getFields()).sorted(Comparator.comparing(PsiField::getName)).map(field -> JavaLookupElementBuilder.forField(field)).toArray();
                }
                case "getField": {
                    THashSet uniqueNames = new THashSet();
                    return Arrays.stream(ownerClass.getPsiClass().getAllFields()).filter(arg_0 -> JavaLangClassMemberReference.lambda$getVariants$3(ownerClass, (Set)uniqueNames, arg_0)).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isPublic((PsiMember)field) ? 0 : 1).thenComparing(PsiField::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field), JavaReflectionReferenceUtil.isPublic((PsiMember)field))).toArray();
                }
                case "getDeclaredMethod": {
                    return Arrays.stream(ownerClass.getPsiClass().getMethods()).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method)).sorted(Comparator.comparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.lookupMethod(method, this)).filter(Objects::nonNull).toArray();
                }
                case "getMethod": {
                    return ownerClass.getPsiClass().getVisibleSignatures().stream().map(MethodSignatureBackedByPsiMethod::getMethod).filter(method -> JavaReflectionReferenceUtil.isRegularMethod(method) && JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)method, ownerClass)).sorted(Comparator.comparingInt(method -> JavaReflectionReferenceUtil.getMethodSortOrder(method)).thenComparing(PsiMethod::getName)).map(method -> JavaReflectionReferenceUtil.withPriority(JavaReflectionReferenceUtil.lookupMethod(method, this), -JavaReflectionReferenceUtil.getMethodSortOrder(method))).filter(Objects::nonNull).toArray();
                }
                case "newUpdater": {
                    return Arrays.stream(ownerClass.getPsiClass().getFields()).sorted(Comparator.comparingInt(field -> JavaReflectionReferenceUtil.isAtomicallyUpdateable(field) ? 0 : 1).thenComparing(PsiField::getName)).map(field -> JavaReflectionReferenceUtil.withPriority((LookupElement)JavaLookupElementBuilder.forField(field), JavaReflectionReferenceUtil.isAtomicallyUpdateable(field))).toArray();
                }
            }
        }
        return EMPTY_ARRAY;
    }

    @Contract(value="null, _ -> false")
    private static boolean isPotentiallyAccessible(PsiMember member, JavaReflectionReferenceUtil.ReflectiveClass psiClass) {
        return member != null && (member.getContainingClass() == psiClass.getPsiClass() || JavaReflectionReferenceUtil.isPublic(member));
    }

    @Nullable
    private PsiElement findOverloadedMethod(PsiMethod[] methods) {
        List<PsiExpression> arguments;
        PsiMethodCallExpression definitionCall = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiMethodCallExpression.class);
        if (definitionCall != null && (arguments = JavaLangClassMemberReference.getReflectionMethodArguments(definitionCall, 1)) != null) {
            List parameterTypes = ContainerUtil.map(arguments, type2 -> JavaReflectionReferenceUtil.getReflectiveType(type2));
            return JavaLangClassMemberReference.matchMethod(methods, parameterTypes);
        }
        return null;
    }

    public void handleInsert(@NotNull InsertionContext context, @NotNull LookupElement item) {
        Object object = item.getObject();
        if (object instanceof JavaReflectionReferenceUtil.ReflectiveSignature) {
            JavaReflectionReferenceUtil.ReflectiveSignature signature = (JavaReflectionReferenceUtil.ReflectiveSignature)object;
            String text2 = signature.getText(false, false, type2 -> type2 + ".class");
            JavaReflectionReferenceUtil.replaceText(context, text2.isEmpty() ? "" : ", " + text2);
        }
    }

    @Nullable
    public static PsiMethod matchMethod(PsiMethod @NotNull [] methods, @NotNull List<? extends JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        int mismatchCount = Integer.MAX_VALUE;
        PsiMethod bestGuess = null;
        for (PsiMethod method : methods) {
            int match = JavaLangClassMemberReference.matchMethodArguments(method, argumentTypes);
            if (match == 0) {
                return method;
            }
            if (match < 0 || mismatchCount <= match) continue;
            mismatchCount = match;
            bestGuess = method;
        }
        return bestGuess;
    }

    private static int matchMethodArguments(PsiMethod method, List<? extends JavaReflectionReferenceUtil.ReflectiveType> argumentTypes) {
        PsiParameter[] parameters2 = method.getParameterList().getParameters();
        if (parameters2.length != argumentTypes.size()) {
            return -1;
        }
        int mismatchCount = 0;
        for (int i = 0; i < parameters2.length; ++i) {
            JavaReflectionReferenceUtil.ReflectiveType argumentType = argumentTypes.get(i);
            if (argumentType == null) {
                ++mismatchCount;
                continue;
            }
            if (argumentType.isEqualTo(parameters2[i].getType())) continue;
            return -1;
        }
        return mismatchCount;
    }

    @Nullable
    public static List<PsiExpression> getReflectionMethodArguments(@NotNull PsiMethodCallExpression definitionCall, int argumentOffset) {
        List<PsiExpression> arrayElements;
        PsiExpression[] arguments = definitionCall.getArgumentList().getExpressions();
        if (arguments.length == argumentOffset + 1 && (arrayElements = JavaReflectionReferenceUtil.getVarargs(arguments[argumentOffset])) != null) {
            return arrayElements;
        }
        if (arguments.length >= argumentOffset) {
            return Arrays.asList(arguments).subList(argumentOffset, arguments.length);
        }
        return null;
    }

    private static /* synthetic */ boolean lambda$getVariants$3(JavaReflectionReferenceUtil.ReflectiveClass ownerClass, Set uniqueNames, PsiField field) {
        return JavaLangClassMemberReference.isPotentiallyAccessible((PsiMember)field, ownerClass) && uniqueNames.add(field.getName());
    }
}

