/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.resolve.ClassResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveClassUtil {
    @Nullable
    public static PsiClass resolveClass(@NotNull PsiJavaCodeReferenceElement ref, @NotNull PsiFile containingFile) {
        if (ref instanceof PsiJavaCodeReferenceElementImpl && ((PsiJavaCodeReferenceElementImpl)ref).getKindEnum(containingFile) == PsiJavaCodeReferenceElementImpl.Kind.CLASS_IN_QUALIFIED_NEW_KIND) {
            PsiClass qualifierClass;
            PsiType qualifierType;
            PsiExpression qualifier;
            PsiNewExpression parent = (PsiNewExpression)PsiTreeUtil.getContextOfType((PsiElement)ref, (Class[])new Class[]{PsiNewExpression.class});
            if (parent != null && (qualifier = parent.getQualifier()) != null && (qualifierType = qualifier.getType()) instanceof PsiClassType && (qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierType)) != null) {
                return qualifierClass.findInnerClassByName(ref.getText(), true);
            }
        } else {
            PsiElement classNameElement = ref.getReferenceNameElement();
            if (classNameElement instanceof PsiIdentifier) {
                String className2 = classNameElement.getText();
                ClassResolverProcessor processor2 = new ClassResolverProcessor(className2, (PsiElement)ref, containingFile);
                PsiScopesUtil.resolveAndWalk(processor2, ref, null);
                if (processor2.getResult().length == 1) {
                    return (PsiClass)processor2.getResult()[0].getElement();
                }
            }
        }
        return null;
    }
}

