/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaModuleSystem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInferenceHelper;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaParserFacade;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.JavaPsiImplementationHelper;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.PsiOldInferenceHelper;
import com.intellij.psi.impl.source.resolve.ResolveClassUtil;
import com.intellij.psi.impl.source.resolve.ResolveVariableUtil;
import com.intellij.psi.impl.source.resolve.graphInference.PsiGraphInferenceHelper;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiResolveHelperImpl
implements PsiResolveHelper {
    private static final Logger LOG = Logger.getInstance(PsiResolveHelperImpl.class);
    private final PsiManager myManager;

    public PsiResolveHelperImpl(@NotNull Project project) {
        this.myManager = PsiManager.getInstance((Project)project);
    }

    @Deprecated
    public PsiResolveHelperImpl(@NotNull PsiManager manager) {
        this.myManager = manager;
    }

    @NotNull
    public JavaResolveResult resolveConstructor(PsiClassType classType, @NotNull PsiExpressionList argumentList, PsiElement place) {
        JavaResolveResult[] result = this.multiResolveConstructor(classType, argumentList, place);
        return result.length == 1 ? result[0] : JavaResolveResult.EMPTY;
    }

    public JavaResolveResult @NotNull [] multiResolveConstructor(@NotNull PsiClassType type2, @NotNull PsiExpressionList argumentList, @NotNull PsiElement place) {
        MethodResolverProcessor processor2;
        PsiClassType.ClassResolveResult classResolveResult = type2.resolveGenerics();
        PsiClass aClass = classResolveResult.getElement();
        if (aClass == null) {
            return JavaResolveResult.EMPTY_ARRAY;
        }
        PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
        if (argumentList.getParent() instanceof PsiAnonymousClass) {
            PsiAnonymousClass anonymous = (PsiAnonymousClass)argumentList.getParent();
            processor2 = new MethodResolverProcessor((PsiClass)anonymous, argumentList, place, place.getContainingFile());
            aClass = anonymous.getBaseClassType().resolve();
            if (aClass == null) {
                return JavaResolveResult.EMPTY_ARRAY;
            }
        } else {
            processor2 = new MethodResolverProcessor(null, argumentList, place, place.getContainingFile());
        }
        ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
        for (PsiMethod constructor : aClass.getConstructors()) {
            if (!processor2.execute((PsiElement)constructor, state)) break;
        }
        return processor2.getResult();
    }

    public PsiClass resolveReferencedClass(@NotNull String referenceText, PsiElement context) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            PsiFile containingFile = ref.getContainingFile();
            LOG.assertTrue(containingFile.isValid(), (Object)referenceText);
            return ResolveClassUtil.resolveClass(ref, containingFile);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public PsiVariable resolveReferencedVariable(@NotNull String referenceText, PsiElement context) {
        return this.resolveVar(referenceText, context, null);
    }

    public PsiVariable resolveAccessibleReferencedVariable(@NotNull String referenceText, PsiElement context) {
        boolean[] problemWithAccess = new boolean[1];
        PsiVariable variable = this.resolveVar(referenceText, context, problemWithAccess);
        return problemWithAccess[0] ? null : variable;
    }

    @Nullable
    private PsiVariable resolveVar(@NotNull String referenceText, PsiElement context, boolean[] problemWithAccess) {
        PsiJavaParserFacade parserFacade = JavaPsiFacade.getInstance((Project)this.myManager.getProject()).getParserFacade();
        try {
            PsiJavaCodeReferenceElement ref = parserFacade.createReferenceFromText(referenceText, context);
            return ResolveVariableUtil.resolveVariable(ref, problemWithAccess, null);
        }
        catch (IncorrectOperationException e) {
            return null;
        }
    }

    public boolean isAccessible(@NotNull PsiMember member, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass) {
        return this.isAccessible(member, member.getModifierList(), place, accessObjectClass, null);
    }

    public boolean isAccessible(@NotNull PsiMember member, @Nullable PsiModifierList modifierList, @NotNull PsiElement place, @Nullable PsiClass accessObjectClass, @Nullable PsiElement currentFileResolveScope) {
        PsiClass containingClass = member.getContainingClass();
        boolean accessible = JavaResolveUtil.isAccessible(member, containingClass, modifierList, place, accessObjectClass, currentFileResolveScope);
        if (accessible && member instanceof PsiClass && !(member instanceof PsiTypeParameter)) {
            accessible = PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible((PsiClass)member, place));
        }
        return accessible;
    }

    public boolean isAccessible(@NotNull PsiPackage pkg, @NotNull PsiElement place) {
        return PsiResolveHelperImpl.isAccessible(moduleSystem -> moduleSystem.isAccessible(pkg.getQualifiedName(), null, place));
    }

    private static boolean isAccessible(Predicate<? super JavaModuleSystem> predicate) {
        return Stream.of(JavaModuleSystem.EP_NAME.getExtensions()).allMatch(predicate);
    }

    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression expr2, boolean dummyImplicitConstructor, final boolean checkVarargs) {
        PsiFile containingFile = expr2.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor((PsiElement)expr2, containingFile){

            @Override
            protected boolean acceptVarargs() {
                return checkVarargs;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, expr2, dummyImplicitConstructor);
        }
        catch (MethodProcessorSetupFailedException e) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        return processor2.getCandidates();
    }

    public boolean hasOverloads(@NotNull PsiCallExpression call) {
        PsiJavaCodeReferenceElement classReference2;
        PsiFile containingFile = call.getContainingFile();
        MethodCandidatesProcessor processor2 = new MethodCandidatesProcessor((PsiElement)call, containingFile, new PsiConflictResolver[0], (List)new SmartList()){

            @Override
            protected boolean acceptVarargs() {
                return true;
            }
        };
        if (call instanceof PsiMethodCallExpression) {
            PsiReferenceExpression methodExpression = ((PsiMethodCallExpression)call).getMethodExpression();
            processor2.setIsConstructor(false);
            processor2.setName(methodExpression.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor2, (PsiJavaCodeReferenceElement)methodExpression, null);
        } else if (call instanceof PsiNewExpression && (classReference2 = ((PsiNewExpression)call).getClassOrAnonymousClassReference()) != null) {
            processor2.setIsConstructor(true);
            processor2.setName(classReference2.getReferenceName());
            PsiScopesUtil.resolveAndWalk(processor2, classReference2, null);
        }
        return processor2.getCandidates().length > 1;
    }

    public CandidateInfo @NotNull [] getReferencedMethodCandidates(@NotNull PsiCallExpression call, boolean dummyImplicitConstructor) {
        return this.getReferencedMethodCandidates(call, dummyImplicitConstructor, false);
    }

    public PsiType inferTypeForMethodTypeParameter(@NotNull PsiTypeParameter typeParameter, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments, @NotNull PsiSubstitutor partialSubstitutor, @Nullable PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        return this.getInferenceHelper(PsiUtil.getLanguageLevel((PsiElement)(parent != null ? parent : typeParameter))).inferTypeForMethodTypeParameter(typeParameter, parameters2, arguments, partialSubstitutor, parent, policy);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments, @NotNull PsiSubstitutor partialSubstitutor, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy) {
        return this.getInferenceHelper(PsiUtil.getLanguageLevel((PsiElement)parent)).inferTypeArguments(typeParameters, parameters2, arguments, null, partialSubstitutor, parent, policy, PsiUtil.getLanguageLevel((PsiElement)parent));
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiParameter @NotNull [] parameters2, PsiExpression @NotNull [] arguments, @NotNull MethodCandidateInfo currentCandidate, @NotNull PsiElement parent, @NotNull ParameterTypeInferencePolicy policy, @NotNull LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, parameters2, arguments, currentCandidate, currentCandidate.getSiteSubstitutor(), parent, policy, languageLevel);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull LanguageLevel languageLevel) {
        return this.inferTypeArguments(typeParameters, leftTypes, rightTypes, PsiSubstitutor.EMPTY, languageLevel);
    }

    @NotNull
    public PsiSubstitutor inferTypeArguments(PsiTypeParameter @NotNull [] typeParameters, PsiType @NotNull [] leftTypes, PsiType @NotNull [] rightTypes, @NotNull PsiSubstitutor partialSubstitutor, @NotNull LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).inferTypeArguments(typeParameters, leftTypes, rightTypes, partialSubstitutor, languageLevel);
    }

    public PsiType getSubstitutionForTypeParameter(PsiTypeParameter typeParam, PsiType param, PsiType arg, boolean isContraVariantPosition, LanguageLevel languageLevel) {
        return this.getInferenceHelper(languageLevel).getSubstitutionForTypeParameter(typeParam, param, arg, isContraVariantPosition, languageLevel);
    }

    @NotNull
    public LanguageLevel getEffectiveLanguageLevel(@Nullable VirtualFile virtualFile) {
        return JavaPsiImplementationHelper.getInstance(this.myManager.getProject()).getEffectiveLanguageLevel(virtualFile);
    }

    @NotNull
    public PsiInferenceHelper getInferenceHelper(@NotNull LanguageLevel languageLevel) {
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_8)) {
            return new PsiGraphInferenceHelper(this.myManager);
        }
        return new PsiOldInferenceHelper(this.myManager);
    }
}

